#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
#
# FILE:
# GRootObj.py
#
# DESCRIPTION:
# Provides the base class that can optionally be used by root objects
# in a GObj based tree.
#
# NOTES:
#


from gnue.common.logic.NamespaceCore import GObjNamespace
from gnue.common.definitions.GObjects import GObj
#
# GRootObj
#
#
class GRootObj(GObj):
  def __init__(self, rootName, xmlElementCallback, xmlParser, *args, **parms):
    GObj.__init__(self,*args, **parms)
    self._triggerNamespaceTree = None
    self._rname = rootName
    self.__xmlElementCallback = xmlElementCallback
    self._xmlParser = xmlParser
    self._xmlnamespaces = {}
    self._standardnamespaces = {}

    # This will store any "global myVar" that the triggers execute.
    self._globalRuntimeNamespace = {}

  def initTriggerSystem(self):
    self._triggerNamespaceTree = GObjNamespace(self,rootName=self._rname)

  def dumpXML(self, treeDump=1, gap="  ", stripPrefixes=None):
    return GObj.dumpXML(self, self.__xmlElementCallback(),
          treeDump, gap, xmlnamespaces=self._standardnamespaces,
          stripPrefixes=stripPrefixes)



