#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# VButton.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Button import Button
import sio

class VButton(Button):
  """ A button that is laid out vertical (i.e. used for the
    vertical-scrollbar buttons)
  """
  def __init__(self, Parent, ButtonName,Y,X,H,Caption,**properties):
    Button.__init__(self, Parent, ButtonName, Y, X, H, Caption,**properties)
    self.W = 1
    self.H = H
    self.SetColor('SCROLL_BUTTON','SCROLL_BUTTON_FOCUS')


  def Paint(self, HaveFocus, v2,v3):
    Container = self.PARENT.SCREEN
    if Container == None:
      raise "Container is Nothing in def Paint!"
    if HaveFocus:
      color = self.FOCUSCOLOR
    else:
      color = self.COLOR
    tROW, tCOL = self._ABSY, self._ABSX
    tCaption = self.CAPTION
    tW = self.H
    tAW = tW - 2
    if len(tCaption) > tAW:
      tCaption = tCaption[: tAW]
    elif len(tCaption) < tAW:    # spaces-stuff: text in the middle
      spaces = tAW - len(tCaption)
      if spaces % 2 == 1:
        spaces += 1
      leadingSpaces =  spaces / 2
      spaces = leadingSpaces
      if spaces + leadingSpaces + len(tCaption) > tAW:
        leadingSpaces -= 1
      elif spaces + leadingSpaces + len(tCaption) < tAW:
        spaces += 1

      tCaption = (" " * leadingSpaces) + tCaption + (" " * spaces)
    tCaption = tCaption
    for i in range(0,len(tCaption)):
      Container.PutAt(tROW + i, tCOL, tCaption[i], color)


