#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GConnections.py
#
# DESCRIPTION:
# Class that handles prompting user for login information
# (design to be subclassed by the UI portion).
#
# NOTES:
#


#
# If user stops the login process (cancel button?), raise this exception
#
class UserCanceledLogin(Exception):
  pass



class LoginHandler:

  # The client app can set any default values for the needed parameters.
  defaults = {}

  #
  # getLogin is passed an list consisting of:
  #   Connection Name
  #   Connection Comments/Description
  #   List of Fields to Input:
  #      Attribute Name, Label/Description, Is Password?
  #
  # It should return a dictionary of {Attribute Name: Inputted Value}
  #
  def getLogin(self, requiredFields, errortext=None):
    pass


  # Called when the app no longer needs the login handler
  def destroyLoginDialog(self):
    pass


#
# This is a basic solution to getting a login
#
try:
  import getpass
except:
  getpass = None

class BasicLoginHandler(LoginHandler):

  defaults = {'_username': None, '_password': None}

  def getLogin(self, loginData, error):
    try:
      print "*"*60
      if len(loginData[1]):
        print 'Attempting to log into "%s" (%s):' % (loginData[1], loginData[0])
      else:
        print 'Attempting to log into %s:' % (loginData[0])
      print
      val = {}
      for prompt in loginData[2]:
        if not (self.defaults.has_key(prompt[0]) and self.defaults.get(prompt[0],None)):
          if prompt[2] and getpass:
            val[prompt[0]] = getpass.getpass("  %s: " % prompt[1])
          else:
            val[prompt[0]] = raw_input("  %s: " % prompt[1])
      print
      print "*"*60
      return val
    except KeyboardInterrupt:
      raise GLoginHandler.UserCanceledLogin


  def destroyLoginDialog(self):
    pass
