# GNU Enterprise Datasource Library - Driver for GNUe-AppServer
#
# Copyright 2000-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: DataObject.py 5628 2004-04-03 23:39:35Z reinhard $

from types import *

import string

from gnue.common.datasources import GConditions
from gnue.common.datasources.drivers import Base

import ResultSet

# =============================================================================
# DataObject class
# =============================================================================

class DataObject (Base.DataObject):
  """
  Handles a dataobject in the GNUe-AppServer backend.
  """
  # This is actually never used
  _resultSetClass = ResultSet.ResultSet

  # ---------------------------------------------------------------------------
  # Build query in prefix notation
  # ---------------------------------------------------------------------------

  def _buildQuery (self, conditions = {}, forDetail = None,
                   additionalSQL = ''):

    if isinstance (conditions, DictType):
      cond = GConditions.buildConditionFromDict (conditions)
    else:
      cond = conditions

    query = GConditions.buildPrefixFromTree (cond._children [0])

    return query

  # ---------------------------------------------------------------------------
  # Create an empty resultset
  # ---------------------------------------------------------------------------

  def _createEmptyResultSet (self, readOnly = 0, masterRecordSet = None):

    fieldlist = self._fieldReferences.keys ()

    return ResultSet.ResultSet (dataObject      = self,
                                sm              = self._connection._sm,
                                session_id      = self._connection._sess_id,
                                list_id         = None,
                                classname       = self.table,
                                fieldlist       = fieldlist,
                                fetchcount      = self.cache,
                                readOnly        = readOnly,
                                masterRecordSet = masterRecordSet)

  # ---------------------------------------------------------------------------
  # Create a resultset
  # ---------------------------------------------------------------------------

  def _createResultSet (self, conditions = {}, readOnly = 0,
                        masterRecordSet = None, sql = ''):

    if conditions:
      filter = self._buildQuery (conditions)
    else:
      filter = []

    if hasattr (self, 'order_by'):
      sort = string.splitfields (self.order_by, ',')
    else:
      sort = []

    fieldlist = self._fieldReferences.keys ()

    list_id = self._connection._sm.request (self._connection._sess_id,
                                            self.table, filter, sort, fieldlist)

    return ResultSet.ResultSet (dataObject      = self,
                                sm              = self._connection._sm,
                                session_id      = self._connection._sess_id,
                                list_id         = list_id,
                                classname       = self.table,
                                fieldlist       = fieldlist,
                                fetchcount      = self.cache,
                                readOnly        = readOnly,
                                masterRecordSet = masterRecordSet)
