#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys


from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection


class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    includeTables = (type in ('table','sources', None))
    includeViews = (type in ('view','sources', None))

    inClause = []
    if includeTables:
      inClause.append ("'r'")
    if includeViews:
      inClause.append ("'v'")

    # TODO: This excludes any system tables and views. Should it?
    statement = "select relname, relkind, oid from pg_class " + \
            "where relkind in (%s) " % (join(inClause,',')) + \
            "and relname not like 'pg_%' " + \
            "order by relname"

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      list.append(GIntrospection.Schema(attrs={'id':rs[2], 'name':rs[0],
                         'type':rs[1] == 'v' and 'view' or 'table',
                         'primarykey': self.__getPrimaryKey(cursor, rs[2])},
                         getChildSchema=self.__getFieldSchema))

    cursor.close()
    return list


  # TODO: Merge into find()
  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    statement = "select relname, relkind, oid from pg_class " + \
            "where relname = '%s'" % (name)

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs:
      schema = GIntrospection.Schema(attrs={'id':rs[2], 'name':rs[0],
                           'type':rs[1] == 'v' and 'view' or 'table',
                           'primarykey': self.__getPrimaryKey(cursor, rs[2]) },
                           getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema

  def __getPrimaryKey(self, cursor, oid):
    cursor = self._connection.native.cursor()
    cursor.execute("select indkey from pg_index where indrelid=%s" % oid)
    rs = cursor.fetchone()
    statement = "select attname from pg_attribute " \
                "where attrelid = %s and attnum = %%s" % oid
    if rs:
      pks = []
      for indpos in string.split(rs[0]):
        cursor.execute(statement % int(indpos))
        pks.append(cursor.fetchone()[0])
      cursor.close()
      return tuple(pks)
    else:
      cursor.close()
      return None

  # Get fields for a table
  def __getFieldSchema(self, parent):

    statement = "select attname, pg_type.oid, typname, " + \
            " attnotnull, atthasdef, atttypmod, attnum, attlen " + \
            "from pg_attribute, pg_type " + \
            "where attrelid = %s and " % (parent.id) + \
            "pg_type.oid = atttypid and attnum >= 0" + \
            "order by attnum"

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():

      attrs={'id': rs[1], 'name': rs[0],
             'type':'field', 'nativetype': rs[2],
             'required': rs[3] and not rs[4]}

      if rs[2] in ('numeric','float4','float8','money','bool','int8','int2','int4'):
        attrs['datatype']='number'
      elif rs[2] in ('date','time','timestamp','abstime','reltime'):
        attrs['datatype']='date'
      else:
        attrs['datatype']='text'

      if rs[7] > 0:
        attrs['length'] = rs[7]
      elif rs[5] != -1: #text field
        attrs['length'] = rs[5] - 4


      # Find any default values
      if rs[4]:
        cursor.execute("select adsrc " + \
                       "from pg_attrdef " + \
                       "where adrelid = %s and adnum = %s" % (parent.id, rs[6]))
        defrs = cursor.fetchone()
        if defrs:
          dflt = defrs[0]
          if dflt[:8] == 'nextval(':
            attrs['defaulttype'] = 'sequence'
            attrs['defaultval'] = split(dflt,"'")[1]
          elif dflt == 'now()':
            attrs['defaulttype'] = 'system'
            attrs['defaultval'] = 'timestamp'
          else:
            attrs['defaulttype'] = 'constant'
            attrs['defaultval'] = dflt

      list.append(GIntrospection.Schema(attrs=attrs))

    cursor.close()
    return list


