#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# SQLRelay/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via SQLRelay's Python Driver
# Requires SQLRelay + Python-DB Driver (http://www.firstworks.com/sqlrelay)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     host=      This is the SQLRelay host for your connection (required)
#                In the format hostname:port (or ipaddr:port)
#

#### THIS IS AN UNTESTED DRIVER ####
####      Any volunteers?       ####


from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

raise "This data driver has not been upgraded to the new format."


try:
  from SQLRelay import PySQLRDB as SIG2api
except ImportError, message:
  tmsg = _("Driver not installed: SQLRelay Python API\n[%s]") % message
  raise GConnections.AdapterNotInstalled, tmsg


class SQLRelay_RecordSet(DBSIG2.RecordSet):
  pass


class SQLRelay_ResultSet(DBSIG2.ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG2.ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = SQLRelay_RecordSet



class SQLRelay_DataObject(DBSIG2.DataObject):
  def __init__(self):
    DBSIG2.DataObject.__init__(self)
    self._DatabaseError = SIG2api.DatabaseError
    self._resultSetClass = SQLRelay_ResultSet


  def connect(self, connectData={}):
    GDebug.printMesg(1,"SQLRelay database driver initializing")

    try: 
      host, port = string.split(connectData['host'],':')
      port = int(port)
    except ValueError: 
      host = connectData['host']
      port = 9000

    try:
      self._dataConnection = SIG2api.connect( host, port, '', \
                   connectData['_username'], \
                   connectData['_password'], \
                   0,1)
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()



  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('view',_('Views'),1),
            ('table',_('Tables'),1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    return []

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    return None

  def _postConnect(self):
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


class SQLRelay_DataObject_Object(SQLRelay_DataObject, \
      DBSIG2.DataObject_Object):

  def __init__(self):
    SQLRelay_DataObject.__init__(self)

  def _buildQuery(self, conditions={},forDetail=None,additionalSQL=""):
    return DBSIG2.DataObject_Object._buildQuery(self, conditions,forDetail,additionalSQL)


class SQLRelay_DataObject_SQL(SQLRelay_DataObject, \
      DBSIG2.DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because SQLRelay_DataObject needs to overwrite
    # some of its values
    DBSIG2.DataObject_SQL.__init__(self)
    SQLRelay_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG2.DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions:

  def __init__(self, connection):
    self.__connection = connection





######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': SQLRelay_DataObject_Object,
  'sql':    SQLRelay_DataObject_SQL
}

