#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# _helpers/ObjectEnabler.py
#
# DESCRIPTION:
# Set of classes that implement an object transport over protocols
# which dont allow that.
#
# NOTES:
# 
#

from gnue.common.apps import GDebug
from gnue.common.rpc.drivers._helpers import ObjectLibrarian, DirectoryServer

import string, sys, thread, traceback

class ObjectEnabler(DirectoryServer.DirectoryServer):
  
  def __init__(self, rpcdef, bindings, params):
    DirectoryServer.DirectoryServer.__init__(self, rpcdef, bindings, params)
    self._dispatchers=[self.objectDispatcher]+self._dispatchers
    ObjectLibrarian._global_GarbageCollector.start_in_new_thread()


  def objectDispatcher(self, method, params):
    # 1. replace object handles in param with the real object
    counter=0
    while counter<len(params):
      p=params[counter]
      if type(p)==type(""):
        if (len(p)==42) and (p[0]=="[") and (p[41]=="]"):
          try:
            p=p[1:41]
            obj=ObjectLibrarian.retrieveObject(p)
            newp=params[0:counter-1]+(obj,)+params[counter+1:]
            params=newp
          except:
            pass
      counter=counter+1;

    # 2. check if an object is called

    if method[0]!='[':
      return (None,0,method,params)
    # just dispatch objects
    # 1. get the object from the objectlibrarian
    # 2. check, if the object is supported by the gfd
    try:
      i=string.index(method,']',1)
      objhandle=method[1:i]
      method=method[i+2:]
    except ValueError:
      tmsg = _("Wrong format of object handler ")+\
             _("in method call %s") % method 
      raise AttributeError, tmsg
    
    # TODO check in service dir, if obj is supported or not
    o=ObjectLibrarian.retrieveObject(objhandle)
    if method!="_close":
      # normal case: call a method or set/get a real attribut
      try:
        server_method=getattr(o,method)
        server_attribute=None
      except AttributeError:
        server_method=None
        try:
          server_attribute=getattr(o,method[4:])
        except AttributeError:
          
          msg=_("Internal XMLRPC server error: method %s can be ")% \
               method +\
               _("found in the directory (build out of a .grpc file),")+\
               _(" but the object doesn't contain this method/attribut.")+\
               _(" Please check you .grpc file for wrong return types.")
          
          raise AttributeError, msg

 
      
      direntry = self.getMethodDirEntry(o._type+"."+method)
      signature=direntry['signature']
      self.checkParamsAgainstSignature(signature,params)
      
      if (server_method!=None):
            
        # call method with params
        result=server_method(*params)
        
      else:
        # simulate a get_X / set_X method
        result=self.emulate_get_set_method(self, server_attribute,
                                           method, params)

    else:
      # special method '_close' for releasing object
      signature= ('string',)
      self.checkParamsAgainstSignature(signature,params)
      result=self.releaseDynamicObject(o)
      
    return (result, signature[0], method, params)



  #
  # Call the requested method
  #
  def call(self, method, params):
    if self._loglevel>0:
      print _("Dispatching: "), method, params 
    

    ## Check if the Method is part of a service or a pointer to a
    ## single object
    ##
    ## Call to an object:  method="[235423456].setAttr"
    ##                     params=[newValue]
    ## Call to an method: (of a service=one object)
    ##                     method="DonutPlace.Management.Restart"

    for i in self._dispatchers:
      (result,rtype,method,params) = i(method,params)

      if rtype:
        # check for empty results (not allowed for XMLRPC)
        if result==None:
          GDebug.printMesg(3,'Transform result None into 1')
          result=1
          return result
    
        # replace real object in param with an object handle
        if type(result)==type(self):  ## both should be instances
          ObjectLibrarian.archiveObject(result)

          # delete the surrounding brackets < >
          rtype=rtype[1:len(rtype)-1]
          # store typeinfo in new object
          result._type=rtype
          
          result=ObjectLibrarian.getObjectReference(result)
          self.registerDynamicObject(result,rtype)

        return result
  
  
  def registerDynamicObject(self,objhandle,type):
    pass
    #
    #  add new methods to dictionary when needed
    #

  def deregisterDynamicObject(self,object):
    pass
    #
    #  remove the new methods from the dictionary if needed
    #

  def releaseDynamicObject(self,object):
    # delete bindings for this object in the method directory
    self.deregisterDynamicObject(object)
    # release object for Object Librarian
    ObjectLibrarian.deferenceObject(object)


    

##############################################################################
# An other way to implement proxy objects: (not used at the moment)
#  
# Used internally by the server to proxy
# between Object-by-Ref and actual objects.
#
class _ObjectByReferenceHandler:

  def __init__(self, oclass):
    self._class = oclass

  # If this makes absolutely no sense, move on and trust the code :)
  def requestHandler(self, method, *params, **args):

    if len(params):

      # If parameters were passed, the first one is always the handle
      refid = params[0]

      # The object's real method doesn't expect to receive the object handle
      params = params[1:]

    else:

      try:

        # If only named parameters are present, then
        # obj_handle should be the object handle...
        refid = args['obj_handle']

        # The object's real method doesn't expect to receive the object handle
        del args['obj_handle']

      except KeyError:
        tmsg = _('Object handle not returned') 
        raise StandardError, tmsg   # TODO

    try:
      return ObjectLibrarian. \
        retrieveObject(refid).__dict__[method](*params, **args)
    except KeyError:

      # Attempt to use an invalid objecthandle
      tmsg = _('Invalid object handle') 
      raise StandardError, tmsg # TODO

