#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# soap/CommDriver.py
#
# DESCRIPTION:
# Class that implements the SOAP driver for GNUe Comm.
#
# NOTES:
# Requires Secret Lab's Python-SOAP interface from
# http://www.pythonware.com/products/soap/



#
# We provide both a client and a server driver
#
CLIENT = 1      # ClientDriver
SERVER = 1      # ServerDriver


from gnue.common.rpc.drivers import GCommBase

try:
  import soaplib
except ImportError:
  print _("\nUnable to load soaplib.  To use the SOAP interface, \n") \
      + _("please install soaplib from:\n") \
      + "    http://www.pythonware.com/products/soap/\n"
  sys.exit()



class ClientDriver(GCommBase.BaseClientDriver): 
  pass


class ServerDriver(GCommBase.BaseServerDriver): 

  def raiseException(self, exception, message):
    raise exception, message



