

################################################
# Define our Donut stuff
################################################
#
# Our donut classes aren't documented. They
# are not the interesting part of this file :)
#

class DonutPlace:
  def __init__(self):
    self.Bakery = Bakery()
    self.Management = Management()


class Management:

  def Restart(self):
    print "System got a RESTART request!"

  def Shutdown(self, secondsToWait=0):
    print "System got a SHUTDOWN request!"

  def Status(self):
    print "System got a STATUS request!"
    return "A-Ok!"


class Bakery:
  def getBakingUnit(self, flavor):
    return BakingUnit(flavor, "Memphis, TN Bakery #1")


class BakingUnit:
  flavor = "glazed"
  unitLocation = "Memphis, TN Bakery #1"

  def __init__(self, flavor, unitLocation):
    self.flavor = flavor
    self.unitLocation = unitLocation

  def get_flavor(self):
    return self.flavor

  def set_flavor(self, flavor):
    self.flavor = flavor

  def get_unitLocation(self):
    return self.unitLocation

  def set_unitLocation(self, unitLocation):
    self.unitLocation = unitLocation


  def requestDelivery(self,address):
    return "packed and delivered ... now!"



################################################
# Expose our stuff via GNUe RPC
################################################

from gnue.common.rpc import GComm
from gnue.common.utils.FileUtils import openResource
from gnue.common.apps.GServerApp import GServerApp
import time


#
# Create a Server instance and expose our services.
#
# GServerApp handles all the nasty server/daemon stuff
# (like going into the background, etc)
#
class DonutServery(GServerApp):

  def setTransports(self,transports):
      self._transports=transports

  def setGrpcFile(self,grpcFile):
      self._grpcFile=grpcFile
  
  def bind(self,handler):
      # Expose our services to the world
      return GComm.bind ( self._grpcFile,
                          self._transports,
                          {'DonutPlace': handler })


  def run(self):

    # Create the various servers
    servers=self.bind(self.requestDonutPlace)

    # Daemonize (if appropriate)
    #GServerApp.run(self)

    # Start the server for the different protocolls
    for key in servers.keys():
      servers[key].serveAsNewThread()      

    # wait for the servers shut down
    try:
      while 1==1:
        time.sleep(199999999)
    except KeyboardInterrupt, SystemExit:
      pass
    

  def requestDonutPlace(self):
    # In real applications, this would probably either
    #  1) Maintain a single DonutPlace that was always used, or
    #  2) Maintain a pool of DonutPlaces that got recycled.
    # We are just testing transports, so we can cheat :)
    print "New Donutplace created"
    return DonutPlace()


#
# The transports to use
#
# This hash gets set via the various
# bind_* methods (below)
#
transports = {}

#
# Use the xmlrpc interface
#
# This binds to port 8765 and exposes an
# XML-RPC interface (using http or https)
#
def bind_xmlrpc():
  print "Exporting our services via xmlrpc..."
  transports['xmlrpc'] =  { 'port': 8765 }

def bind_pw_xmlrpc():  # xmlrpc by pythonware
  print "Exporting our services via xmlrpc..."
  transports['pw_xmlrpc'] =  { 'port': 8765 }

#
# Use the sockets interface
#
# This binds to port 8766 and exposes our
# non-standard sockets interface.
#
def bind_sockets():
  print "Exporting our services via sockets..."
  transports['sockets'] =  { 'port': 8765 }

#
# Use the pyro interface
#
# This binds to the standart pyro port 
#
def bind_pyro():
  print "Exporting our services via sockets..."
  transports['pyro'] =  { 'port': 8765 }



#
# Use the proxy transport
#
# This test is different than the others.
# It only gets called by the test.py script.
# It does not use GServerApp (since it doesn't
# actually go into a "server" mode.)
#
def create_proxy():
  print "Exporting our services via proxy..."
  transports['proxy'] = {}

# do some tricks to get the path of donuts.grpc
# get the local file name and cut of the last 9 chars: "server.py"
  import string
  grpcFile=__file__[:string.rfind(__file__,'/')]+"/donuts.grpc"
  
  serverlist=GComm.bind ( grpcFile,
                      transports,
                      {'DonutPlace': __request })
  return serverlist['proxy']

def __request():
  return DonutPlace()


#
#  start the server
#
def run():

  server=DonutServery()
  server.setTransports(transports)
  
# do some tricks to get the path of donuts.grpc
# get the local file name and cut of the last 9 chars: "server.py"
  import string
  grpcFile=__file__[:string.rfind(__file__,'/')]+"/donuts.grpc"
  grpcFile = 'donuts.grpc'
  server.setGrpcFile(grpcFile)
  server.run()


#
# main
#
if __name__ == '__main__':
  bind_xmlrpc()
#  bind_pw_xmlrpc()
# bind_sockets()
  bind_pyro()
  run()

