#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# MenuBar.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Frame import Frame
from Menu import Menu


class MenuBar(Frame):
  def __init__(self, Root, Y, X, W,  **properties):
    Frame.__init__(self, Root, Y, X, Y+1, X + W - 1,
                   border=0, dropshadow=0, **properties)
    assert gDebug(0,'WIDTH=%s' % W)
    self.rootwin = Root
    self.CANGETFOCUS = 0
    self.Y = Y
    self.X = X
    self.H = 1
    self.W = W
    self.STATUSBAR = None
    self.STATUSBAR_INDEX = 0
    self.Controls = []
    self.SetColor('MENUBAR')
    self.VISIBLE = 1

  def NewMenu(self,Name,Caption):
    newEntry = Menu(self.rootwin, Name, 0,0, Caption, self)
    self._AddMenu(newEntry)
    return newEntry

  def SetStatusBar(self, statusbar, index=0):
    assert gDebug(0,'SETTING STATUSBAR')
    self.STATUSBAR = statusbar
    self.STATUSBAR_INDEX = index

  def _AddMenu(self,menu):
    newX = 1
    if len(self.Controls) > 0:
      newX  = self.Controls[-1:][0].X
      newX += len(self.Controls[-1:][0].CAPTION) + 2

    menu.X = newX
    menu.Y = self.Y

    self.AddControl(menu)

#  def Paint(self, *args, **parms):
#    Container = self.PARENT.Screen()
#    color = self.COLOR
#    #Y = self.Y
#    #X = self.X
#    Y = self.Y
#    X = self.X
#    caption = self.CAPTION
#    Container.PrintAt(Y,X," " * self.W, color)


