#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# VScrollBar.py
#
# DESCRIPTION:
#
# NOTES:
#


import math
import curses
import sio

from constants import *
from VButton import VButton
from ScrollBar import ScrollBar

class VScrollBar(ScrollBar):
  """
  """
  def __init__(self, Parent, SBName, Y, X, H, **properties):
    ScrollBar.__init__(self, Parent, SBName, Y,X,1,**properties)
    self.H = H
    self.W = 1
    self.Y = Y
    self.X = X
    self.__initButtons()

  def __initButtons(self):
    Y = self.Y
    X = self.X
    H = self.H
    Parent = self.PARENT
##    self.rightarrow = VButton(Parent,'rightarrow',Y+H-2,X,3,'^')
##    self.rightarrow.SetMethod("CLICK",self._Dec)
##    Parent.AddControl(self.rightarrow)
    self.left2arrow = VButton(Parent,'left2arrow',Y+H-1,X,3,'v')
    self.left2arrow.SetMethod("CLICK",self._Inc)
    Parent.AddControl(self.left2arrow)
    self.leftarrow = VButton(Parent,'leftarrow',Y,X,3,'^')
    self.leftarrow.SetMethod("CLICK",self._Dec)
    Parent.AddControl(self.leftarrow)
    self.SetColor('SCROLL_BACKGROUND')

  def Init(self, Max):
    self._max = Max
    self._val = 0
    self.start = self.Y+ 3
    self.WorkingArea = float(self.H-9)
    self.UsedSpace = int(math.floor(self.WorkingArea / float(self._max)))
    self.stepsize = self.WorkingArea / self._max
    if self.UsedSpace < 1:
      self.UsedSpace = 1
    self.Paint(None,None,None)

  def Paint(self,v1,v2,v3):
    Pos = int(math.ceil(float(self._val) * (self.stepsize))) + self.Y + self.start
    Screen = self.PARENT.Screen()
    Screen.AutoRefresh = 0
    # clear the bar region in reverse standard-color
    for i in range(0, int(self.WorkingArea)):
      Screen.PutAt( self.Y + self.start + i,self.X, '|', Screen.colors.C_BACKGROUND)
    # correct position
    if Pos >= (self.WorkingArea + self.start):
      Pos = (self.start + self.WorkingArea)
    elif Pos < (self.start + self.UsedSpace):
      Pos = self.start + self.UsedSpace
    # draw the handle
    if self.FOCUS:
      color = self.SCREEN.colors.C_SCROLL_SLIDER_FOCUS
    else:
      color = self.SCREEN.colors.C_SCROLL_SLIDER

    for i in range(0, self.UsedSpace):
      Screen.PutAt((self.Y + Pos - self.UsedSpace) + i,self.X, '0', color)
    Screen.AutoRefresh = 1
    Screen.Refresh()

  def _ChangePos(self,arg1,newY,arg3):
    Screen = self.PARENT.Screen()
    Y = newY - self.start
##    Screen.PrintAt(0,0,'Y = ' + str(Y) + '  ' + str(self.WorkingArea))
    if Y >= (self.WorkingArea-1):
      val = self._max
    else:
      val = float(Y) / self.stepsize
      val = int(math.ceil(val))
    self.Set(val)
    self._Action()

  def __del__(self):
    Parent = self.PARENT
    Parent.DelControl(self.rightarrow)
    Parent.DelControl(self.leftarrow)
    Parent.DelControl(self.left2arrow)


