#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# TriggerEditor.py
#
# DESCRIPTION:
#
# NOTES:
#


from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.definitions import GParserHelpers
from gnue.common.logic import GTrigger
from gnue.designer.base.ToolBase import *
import keyword, string



# What Mode are we in?
NAMED_TRIGGER = 1
EVENT_TRIGGER = 0


class TriggerEditor (ToolBase):

  runtime_section = "TriggerEditor"
  default_width  = int(wxSystemSettings_GetSystemMetric( wxSYS_SCREEN_X )/3)
  default_height = int(wxSystemSettings_GetSystemMetric( wxSYS_SCREEN_Y )/3)
  default_dock = 'right-2'

  def init(self):

    if USE_STC:
      EditorCtrl = PythonEditorControl
      print "1"
    else:
      EditorCtrl = FallbackPythonEditorControl
      print "2"
    self.editor = EditorCtrl(self,-1, pos=wxPoint(0,32))
    self.editor.InEditMode = 0


#    self.SetSize(self.frame.GetClientSize())
#    self.editor.SetSize(self.GetClientSize())
    self.object = None

    self.triggerList = []
    self.triggerMap = {}


    self.editor.SetReadOnly(1)
    EVT_SIZE(self, self._onSize)
    EVT_KILL_FOCUS(self.editor, self.OnKillFocus)
    self.__ignoreevent = 0

    self.mode = NAMED_TRIGGER

    self.toolpanel = wxPanel(self, -1, pos=wxPoint(0,0), size=wxSize(32,32), style=wxRAISED_BORDER|wxCLIP_CHILDREN)

    self.namedNameLabel = wxStaticText(self.toolpanel, -1, _("Trigger: "), pos=wxPoint(4,6))
    self.triggerCombo = wxComboBox(self.toolpanel, -1,  choices=['This is to make the combo box big enough'],pos=wxPoint(self.namedNameLabel.GetSize().width + 10,4), style=wxCB_READONLY)
    self.toolh = max(self.namedNameLabel.GetSizeTuple()[1], self.triggerCombo.GetSizeTuple()[1]) + 12
    self.triggerCombo.Clear()
    self.triggerCombo.Append('')
    self.editor.SetPosition((0, self.toolh))

    EVT_COMBOBOX(self, self.triggerCombo.GetId(), self.OnTriggerSelected)


    # EventAware provided by ToolBase
    self.registerEventListeners({
                       'ObjectSelected'      : self.onSetCurrentObject,
                       'TriggerSelected'     : self.onSetCurrentObject,
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })

    self.rootObject.walk(self.inventoryObject)
#    if self.object:
#      self._setObject(object)


  def OnTriggerSelected(self, event):
    s= event.GetSelection()
    if s:
      trigger = self.triggerMap[self.triggerList[s-1]]
      wxCallAfter(self.dispatchEvent,'TriggerSelected',
                       object = trigger,
                       originator = None)
      if trigger.type.upper() != 'NAMED':
        wxCallAfter(self.dispatchEvent,'ObjectSelected',
                           object = trigger._parent,
                           originator = None)

      self.editor.SetReadOnly(0)
    else:
      self.editor.InEditMode = 0
      self.editor.SetText("")
      self.editor.EmptyUndoBuffer()
      self.editor.InEditMode = 1
      self.editor.SetReadOnly(1)
      self.object = None
    event.Skip()


  def _onSize(self, event):
    w,h = self.GetClientSizeTuple()
    self.toolpanel.SetSize(wxSize(w,self.toolh))
    self.editor.SetSize(wxSize(w,h-self.toolh+1))


  def onSetCurrentObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return

    if isinstance(object, GTrigger.GTrigger) and not object.src:
      self._setObject(object)


  def _setObject(self, object):
      self.__ignoreevent = 0

      self.object = object
      self.editor.SetReadOnly(0)

      if not len(object._children):
        GParserHelpers.GContent(object, "")
      elif len(object._children) > 1:
        content = object.getChildrenAsContent()
        object._children = []
        GParserHelpers.GContent(object, content)

      self.editor.InEditMode = 0
      self.editor.SetText(object.getChildrenAsContent())
      self.editor.EmptyUndoBuffer()
      self.editor.Colourise(0, -1)
      self.editor.InEditMode = 1

      i = self.triggerList.index(self._generateName(object)) + 1
      self.triggerCombo.SetSelection(i)

  def refillTriggerCombo(self):
    i = self.triggerCombo.GetSelection()
    if i>0:
      cur = self.triggerList[i-1]
    else:
      cur = None
    nt = []
    ct = []

    for key, trigger in self.triggerMap.items():
      if trigger.type.upper() == 'NAMED':
        nt.append(key)
      else:
        ct.append(key)

    nt.sort()
    ct.sort()

    self.triggerList = nt + ct

    self.triggerCombo.Clear()
    self.triggerCombo.Append('')
    for i in range(0, len(self.triggerList)):
      self.triggerCombo.Append(self.triggerList[i])

    try:
      i = self.triggerList.index(cur) + 1
    except:
      i = 0


    self.triggerCombo.SetSelection(i)
    try:
      self._setObject(self.triggerMap[self.triggerList[i - 1]])
    except KeyError:
      pass

    self.Refresh()

  def _generateName(self, trigger):
    if trigger.type.upper() == 'NAMED':
      return trigger.name
    else:
      parent = trigger._parent
      name = '%s.%s' % (parent.name, parent._validTriggers[trigger.type.upper()])
      try:
        name = parent._parent.name + '.' + name
      except:
        pass
      return '('+name+')'



  def inventoryObject(self, object):
    if isinstance(object, GTrigger.GTrigger):
      if not object.src:
        self.triggerMap[self._generateName(object)] = object
        self.refillTriggerCombo()

  def OnKillFocus(self, event):
    # TODO: We might be able to ditch this now since it's done in onChange
    if self.object != None and not self.__ignoreevent:
      self.object._children[0]._content = self.editor.GetText()

  def onCreateObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return

    self.inventoryObject(object)

  def onModifyObject (self, event):
    object = event.object
    handler = event.originator

    if object == None:
      return
    if handler != __name__:

      if isinstance(object, GTrigger.GTrigger):
        if object.type == 'NAMED':
          self.refillTriggerCombo()


  def onDeleteObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return

    if isinstance(object, GTrigger.GTrigger) and not object.src:
      del self.triggerMap[self._generateName(object)]
      self.refillTriggerCombo()


try:

 if int(gConfig('ForceSimpleEditor',section="designer")):
   raise ImportError

 from wxPython.stc import *
 USE_STC = 1


#
# A Python Editor Control using wxPython's Scintilla support.
# This class is largely based on demo code from wxPython
#

 class PythonEditorControl(wxStyledTextCtrl):
  def __init__(self, parent, *args, **parms):
    wxStyledTextCtrl.__init__(self, parent, *args, **parms)

    self.instance = parent.instance
    self.parent = parent

    self.CmdKeyAssign(ord('B'), wxSTC_SCMOD_CTRL, wxSTC_CMD_ZOOMIN)
    self.CmdKeyAssign(ord('N'), wxSTC_SCMOD_CTRL, wxSTC_CMD_ZOOMOUT)

    self.SetLexer(wxSTC_LEX_PYTHON)
    self.SetKeyWords(0, string.join(keyword.kwlist))

    self.SetProperty("fold", "1")
    self.SetProperty("tab.timmy.whinge.level", "1")
    self.SetMargins(0,0)

    self.SetViewWhiteSpace(false)
    #self.SetBufferedDraw(false)

    self.SetEdgeMode(wxSTC_EDGE_BACKGROUND)
    self.SetEdgeColumn(78)

    # Setup a margin to hold fold markers
    #self.SetFoldFlags(16)  ###  WHAT IS THIS VALUE?  WHAT ARE THE OTHER FLAGS?  DOES IT MATTER?
    self.SetMarginType(2, wxSTC_MARGIN_SYMBOL)
    self.SetMarginMask(2, wxSTC_MASK_FOLDERS)
    self.SetMarginSensitive(2, true)
    self.SetMarginWidth(2, 15)
    self.MarkerDefine(wxSTC_MARKNUM_FOLDER, wxSTC_MARK_ARROW, "navy", "navy")
    self.MarkerDefine(wxSTC_MARKNUM_FOLDEROPEN, wxSTC_MARK_ARROWDOWN, "navy", "navy")
##    self.MarkerDefine(wxSTC_MARKNUM_FOLDERSUB, wxSTC_MARK_VLINE , "navy", "navy")


##    self.MarkerDefine(wxSTC_MARKNUM_FOLDERTAIL, 0, "navy", "navy") # Collapsed
##    self.MarkerDefine(wxSTC_MARKNUM_FOLDEREND, 0, "navy", "navy") # Collapsed
##    self.MarkerDefine(wxSTC_MARKNUM_FOLDEROPENMID, wxSTC_MARK_VLINE,  "navy", "navy") # Expanded
##    self.MarkerDefine(wxSTC_MARKNUM_FOLDERMIDTAIL, wxSTC_MARK_VLINE, "navy", "navy") # End of Nested Folder
    # Inside of Folder Marker


    EVT_STC_UPDATEUI(self,    self.GetId(), self.OnUpdateUI)
    EVT_STC_MARGINCLICK(self, self.GetId(), self.OnMarginClick)
    EVT_STC_MODIFIED(self, self.GetId(), self.OnChange)


    # Make some styles,  The lexer defines what each style is used for, we
    # just have to define what each style looks like.  This set is adapted from
    # Scintilla sample property files.

    self.StyleClearAll()


    # TODO: A lot of this should be configurable

    if int(gConfig('ColorizeCode',section="designer")):

      # Global default styles for all languages
      self.StyleSetSpec(wxSTC_STYLE_DEFAULT,     "face:%(helv)s,size:%(size)d" % faces)
      self.StyleSetSpec(wxSTC_STYLE_LINENUMBER,  "back:#C0C0C0,face:%(helv)s,size:%(size2)d" % faces)
      self.StyleSetSpec(wxSTC_STYLE_CONTROLCHAR, "face:%(other)s" % faces)
      self.StyleSetSpec(wxSTC_STYLE_BRACELIGHT,  "fore:#FFFFFF,back:#0000FF,bold")
      self.StyleSetSpec(wxSTC_STYLE_BRACEBAD,    "fore:#000000,back:#FF0000,bold")

      # Python styles
      # White space
      self.StyleSetSpec(wxSTC_P_DEFAULT, "fore:#808080,face:%(helv)s,size:%(size)d" % faces)
      # Comment
      self.StyleSetSpec(wxSTC_P_COMMENTLINE, "fore:#007F00,face:%(other)s,size:%(size)d" % faces)
      # Number
      self.StyleSetSpec(wxSTC_P_NUMBER, "fore:#007F7F,size:%(size)d" % faces)
      # String
      self.StyleSetSpec(wxSTC_P_STRING, "fore:#7F007F,italic,face:%(times)s,size:%(size)d" % faces)
      # Single quoted string
      self.StyleSetSpec(wxSTC_P_CHARACTER, "fore:#7F007F,italic,face:%(times)s,size:%(size)d" % faces)
      # Keyword
      self.StyleSetSpec(wxSTC_P_WORD, "fore:#00007F,bold,size:%(size)d" % faces)
      # Triple quotes
      self.StyleSetSpec(wxSTC_P_TRIPLE, "fore:#7F0000,size:%(size)d" % faces)
      # Triple double quotes
      self.StyleSetSpec(wxSTC_P_TRIPLEDOUBLE, "fore:#7F0000,size:%(size)d" % faces)
      # Class name definition
      self.StyleSetSpec(wxSTC_P_CLASSNAME, "fore:#0000FF,bold,underline,size:%(size)d" % faces)
      # Function or method name definition
      self.StyleSetSpec(wxSTC_P_DEFNAME, "fore:#007F7F,bold,size:%(size)d" % faces)
      # Operators
      self.StyleSetSpec(wxSTC_P_OPERATOR, "bold,size:%(size)d" % faces)
      # Identifiers
      self.StyleSetSpec(wxSTC_P_IDENTIFIER, "fore:#202020,face:%(helv)s,size:%(size)d" % faces)
      # Comment-blocks
      self.StyleSetSpec(wxSTC_P_COMMENTBLOCK, "fore:#7F7F7F,size:%(size)d" % faces)
      # End of line where string is not closed
      self.StyleSetSpec(wxSTC_P_STRINGEOL, "fore:#000000,face:%(mono)s,back:#E0C0E0,eolfilled,size:%(size)d" % faces)

    self.SetCaretForeground("BLUE")

    EVT_KEY_DOWN(self, self.OnKeyPressed)


  def OnKeyPressed(self, event):    
    print "press"
    key = event.KeyCode()
    if key == 32 and event.ControlDown():
      pos = self.GetCurrentPos()
      # Tips
      if event.ShiftDown():

        # TODO: Implement ToolTips

        self.CallTipSetBackground("yellow")
        self.CallTipShow(pos, 'param1, param2')
        # Code completion
      else:

        # TODO: Implement AutoComplete

        #lst = []
        #for x in range(50000):
          #    lst.append('%05d' % x)
          #st = string.join(lst)
          #print len(st)
          #self.AutoCompShow(0, st)

        kw = keyword.kwlist[:]
        kw.append("zzzzzz")
        kw.append("aaaaa")
        kw.append("__init__")
        kw.append("zzaaaaa")
        kw.append("zzbaaaa")
        kw.append("this_is_a_longer_value")
        kw.append("this_is_a_much_much_much_much_much_much_much_longer_value")

        kw.sort()  # Python sorts are case sensitive
        self.AutoCompSetIgnoreCase(false)  # so this needs to match

        self.AutoCompShow(0, string.join(kw))
    else:
      event.Skip()

  def OnChange(self, evt):
    if self.InEditMode:
      self.instance.makeDirty()
      self.parent.object._children[0]._content = self.GetText()
      
  def OnUpdateUI(self, evt):
    # check for matching braces
    braceAtCaret = -1
    braceOpposite = -1
    charBefore = None
    caretPos = self.GetCurrentPos()
    if caretPos > 0:
      charBefore = self.GetCharAt(caretPos - 1)
      styleBefore = self.GetStyleAt(caretPos - 1)

    # check before
    if charBefore and chr(charBefore) in "[]{}()" and styleBefore == wxSTC_P_OPERATOR:
      braceAtCaret = caretPos - 1

    # check after
    if braceAtCaret < 0:
      charAfter = self.GetCharAt(caretPos)
      styleAfter = self.GetStyleAt(caretPos)
      if charAfter and chr(charAfter) in "[]{}()" and styleAfter == wxSTC_P_OPERATOR:
        braceAtCaret = caretPos

    if braceAtCaret >= 0:
      braceOpposite = self.BraceMatch(braceAtCaret)

    if braceAtCaret != -1  and braceOpposite == -1:
      self.BraceBadLight(braceAtCaret)
    else:
      self.BraceHighlight(braceAtCaret, braceOpposite)
      #pt = self.PointFromPosition(braceOpposite)
      #self.Refresh(true, wxRect(pt.x, pt.y, 5,5))
      #print pt
      #self.Refresh(false)


  def OnMarginClick(self, evt):
    # fold and unfold as needed
    if evt.GetMargin() == 2:
      if evt.GetShift() and evt.GetControl():
        self.FoldAll()
      else:
        lineClicked = self.LineFromPosition(evt.GetPosition())
        if self.GetFoldLevel(lineClicked) & wxSTC_FOLDLEVELHEADERFLAG:
          if evt.GetShift():
            self.SetFoldExpanded(lineClicked, true)
            self.Expand(lineClicked, true, true, 1)
          elif evt.GetControl():
            if self.GetFoldExpanded(lineClicked):
              self.SetFoldExpanded(lineClicked, false)
              self.Expand(lineClicked, false, true, 0)
            else:
              self.SetFoldExpanded(lineClicked, true)
              self.Expand(lineClicked, true, true, 100)
          else:
             self.ToggleFold(lineClicked)


  def FoldAll(self):
    lineCount = self.GetLineCount()
    expanding = true

    # find out if we are folding or unfolding
    for lineNum in range(lineCount):
      if self.GetFoldLevel(lineNum) & wxSTC_FOLDLEVELHEADERFLAG:
        expanding = not self.GetFoldExpanded(lineNum)
        break;

    lineNum = 0
    while lineNum < lineCount:
      level = self.GetFoldLevel(lineNum)
      if level & wxSTC_FOLDLEVELHEADERFLAG and \
               (level & wxSTC_FOLDLEVELNUMBERMASK) == wxSTC_FOLDLEVELBASE:

        if expanding:
          self.SetFoldExpanded(lineNum, true)
          lineNum = self.Expand(lineNum, true)
          lineNum = lineNum - 1
        else:
          lastChild = self.GetLastChild(lineNum, -1)
          self.SetFoldExpanded(lineNum, false)
          if lastChild > lineNum:
            self.HideLines(lineNum+1, lastChild)

      lineNum = lineNum + 1


  def Expand(self, line, doExpand, force=false, visLevels=0, level=-1):
    lastChild = self.GetLastChild(line, level)
    line = line + 1
    while line <= lastChild:
      if force:
        if visLevels > 0:
          self.ShowLines(line, line)
        else:
          self.HideLines(line, line)
      else:
        if doExpand:
          self.ShowLines(line, line)

      if level == -1:
        level = self.GetFoldLevel(line)

      if level & wxSTC_FOLDLEVELHEADERFLAG:
        if force:
          if visLevels > 1:
            self.SetFoldExpanded(line, true)
          else:
            self.SetFoldExpanded(line, false)
          line = self.Expand(line, doExpand, force, visLevels-1)

        else:
          if doExpand and self.GetFoldExpanded(line):
            line = self.Expand(line, true, force, visLevels-1)
          else:
            line = self.Expand(line, false, force, visLevels-1)
      else:
        line = line + 1;

    return line


  # The old code used SetEnabled, so we emulate that call here
  def SetEnabled(self, bool):
    self.SetReadOnly(bool)

except ImportError:
  USE_STC = 0
  GDebug.printMesg (1,
      'Unable to load wxPython.stc, using fallback text editor')


#
# <cough>Hack!<cough>
#
# TODO: A lot of this should be configurable
if wxPlatform == '__WXMSW__':
  faces = { 'times': 'Courier New',
            'mono' : 'Courier New',
            'helv' : 'Courier New',
            'other': 'Courier New',
            'size' : 10,
            'size2': 10,
          }
else:
#  faces = { 'times': 'Times',
#            'mono' : 'Courier',
#            'helv' : 'Helvetica',
#            'other': 'Courier',
#            'size' : 10,
#            'size2': 8,
#          }
  faces = { 'times': 'Courier',
            'mono' : 'Courier',
            'helv' : 'Courier',
            'other': 'Courier',
            'size' : 10,
            'size2': 10,
          }


#
#  This provides a "fallback" control for platforms not supporting wxPython.stc
#
class FallbackPythonEditorControl(wxTextCtrl):

  def __init__(self, *args, **parms):
    wxTextCtrl.__init__(self, *args, **parms)
    self.GetText = self.GetValue
    self.SetText = self.SetValue
    self.Colourise = self.__ignore
    self.ClearUndoBuffer = self.__ignore
    self.EmptyUndoBuffer = self.__ignore

  def SetReadOnly(self, bool):
    self.SetEditable(not bool)

  def __ignore(self, *args, **params):
    pass


