#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# DisplayDropTarget.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from Utils import *
from gnue.common.apps import GDebug

import cPickle

#
# Drag and Drop support for our grid
#
class DisplayDropTarget(wxPyDropTarget):

  def __init__(self, editor):
    wxPyDropTarget.__init__(self)
    self.editor = editor

    self.data = wxCustomDataObject(wxCustomDataFormat("application/x-gnue-designer"))
    self.SetDataObject(self.data)

  def OnEnter(self, x, y, d):
    return d

  def OnLeave(self):
    pass

  def OnDrop(self, x, y):
    pass

  def OnDragOver(self, x, y, d):
    return d

  # Called when OnDrop returns true.  We need to get the data and
  # do something with it.
  def OnData(self, bx, by, d):

    instance = self.editor.instance

    # copy the data from the drag source to our data object
    if self.GetData():
      # convert it back to our format
      data = self.data.GetData()
      unpickled = cPickle.loads(data)


      nextY = int(by / self.editor.gridHeight)
      x = int(bx / self.editor.gridWidth)
      for params in unpickled:
        y = nextY

        if params['Type'] == 'SchemaDrop':
          self.schemaDrop(params, bx, by)
          continue

        # TODO: Most of this crap can be purged out of here
        # TODO: schemaDrop replaced most of it

        attributes = params['Attributes']

        # Entry types require a "block".. find or create one
        if params['Type'] in ('entry',):
          try:
            parent = params['Block']
          except KeyError:
            # Find the parent block

            parent = None

            if  not attributes.has_key('block') and \
                attributes.has_key('datasource'):

              datasource = string.lower(attributes['datasource'])

              for child in self.editor.page._children:
                if child._type == 'GFBlock' and \
                  hasattr(child,'datasource') and \
                  string.lower(child.datasource) == datasource:
                  parent = child
                  break

              if parent is None:
                dlg = wxMessageDialog(NULL,
                  "The current page does not have a block\n"
                  "corresponding to Data Source %s.\n"
                  "Create a new block on the current page?" % \
                       attributes['datasource'],
                  "No Target Block Found", style=wxYES_NO|wxICON_WARNING)
                save = dlg.ShowModal()
                dlg.Destroy()
                if save == wxID_NO:
                  return d # TODO: This should actually return a failure

                # Create a parent block
                parent = instance.incubator.createObject(
                            instance.rootObject,
                            'block',
                            self.editor.page,
                            attributes={'datasource':datasource})
            else:
              for child in self.editor.page._children:
                if child._type == 'GFBlock' and \
                   child.name == attributes['block']:

                  parent = child
                  break

          try:
            defaulttype = params['DefaultType']
            defaultval = params['DefaultVal']
            if defaulttype == 'constant':
              if defaultval[:1] in "\"'":
                defaultval = defaultval [1:-2]
              attributes['default'] = defaultval
          except KeyError:
            pass



          createLabels = "left" # TODO: string.lower(gConfig("CreateLabelsOnDrop"))

          if createLabels != "no":
            label = params["Label"] + ":"

            # Figure out the position of the label
            # If the entry is for a multirow block,
            # we assume that the label goes above.
            if createLabels == "left" and\
               not(hasattr(parent,'rows') and parent.rows > 1 or 0):
              lx = x - len(label) - 1
              if lx < 0:
                x = len(label) + 1
                lx = 0
              ly = y
            else:  # "above"
              nextY += 1
              lx = x
              ly = y - 1

              if ly < 0:
                ly = 0
                y += 1

            # Create a label
            instance.incubator.createObject(
                    instance.rootObject,
                    'label',
                    self.editor.page,
                    attributes={'x': lx,
                                'y': ly,
                                'width': len(label),
                                'text': label })
          nextY += 1

        elif params['Type'] in ('datasource',):
          parent = self.editor.rootObject

        elif params['Type'] in ('block',):
          parent = self.editor.page
        elif params['Type'] in ('selectedWidgets',):
          xshift = x - int(attributes['startingX'])
          yshift = y - int(attributes['startingY'])
          for widget in self.editor._currentSelection:
            widget._widgetHandler.relativeMove(xshift,yshift)
        else:
          parent = self.editor.page
          nextY += 1

        attributes['x'] = x
        attributes['y'] = y


        #
        # Create our new object
        #
        if not params['Type'] in ('selectedWidgets',):
          object = instance.incubator.createObject(
            instance.rootObject,
            params['Type'],
            parent,
            attributes=attributes)

          if params['Type'] in ('entry',):
            try:
              defaulttype = params['DefaultTrigger']
              defaultval = params['DefaultInfo']
              triggertext = ""
              if defaulttype == 'sequence':
                triggertext = "\n# Set default value\n" \
                            + "if self.isEmpty():\n" \
                            + "  self.autofillBySequence('%s')\n" % defaultval
              if defaulttype == 'system' and defaultval == 'timestamp':
                triggertext = "\n# Set default value\n" \
                            + "if self.isEmpty():\n" \
                            + "  self.value = %s.extensions.getTimeStamp()\n" \
                              % parent.datasource


              if triggertext:
                instance.incubator.createObject(
                    instance.rootObject,
                    'trigger',
                    object,
                    attributes = {
                      '_content_': triggertext,
                      'type': 'PRE-INSERT',
                      'name': '%s_PreInsert' % object.name
                    })

            except KeyError:
              pass


    return d  # what is returned signals the source what to do
              # with the original data (move, copy, etc.)  In this
              # case we just return the suggested value given to us.


  #
  # This handles dropping from the Schema Navigator
  #
  def schemaDrop(self, params, x, y):

    try:
      table, fields = params['Data'][0]
    except:
      return

    instance = self.editor.instance

    # TODO: if params['ShowMenu'], give user options

    blocks = []
    for set in ((self.editor.block,),instance.blocks):
      for test in set:
        try:
          datasource = instance.datasources[test.datasource]
          if datasource.connection.lower() == table['connection'].lower() and \
             datasource.table.lower() == table['name'].lower():
            blocks.append(test)
        except (KeyError, AttributeError):
          pass

    if not params['ShowMenu']:
      # User left-click-dragged, so do the default action
      if blocks:
        self.schemaDrop_Add(table, fields, blocks[0], x, y)
      else:
        self.schemaDrop_Create(table, fields, x, y)
    else:
      # Present a menu of options
      menu = wxMenu()
      current = 0
      if blocks and blocks[0] == self.editor.block:
        wid = wxNewId()
        menu.Append(wid, _('Add Fields to Current Block'))
        current = 1
        EVT_MENU(menu, wid,
             lambda event, s=self, t=table, f=fields, x=x, y=y,
                           b=blocks[0]: s.schemaDrop_Add(t, f, b, x, y) )
      wid = wxNewId()
      menu.Append(wid, _('Add Fields to New Block'))
      EVT_MENU(menu, wid,  lambda event, s=self, t=table, x=x, y=y,
                                f=fields: s.schemaDrop_Create(t, f, x, y) )
      if len(blocks) > 1 + current:
        smenu = wxMenu()
        menu.AppendMenu(wxNewId(), _("Add Fields to Block"), smenu)
        for block in blocks[1:]:
          wid = wxNewId()
          smenu.Append(wid, block.name)
          EVT_MENU(smenu, wid,
               lambda event, s=self, t=table, f=fields, x=x, y=y,
                             b=block: s.schemaDrop_Add(t, f, b, x, y) )

## TODO: Finish schemaDrop_Dropdown
##      menu.AppendSeparator()
##      wid = wxNewId()
##      menu.Append(wid, _("Add as a dropdown to current block"))
##      EVT_MENU(menu, wid,
##            lambda event, s=self, t=table, x=x, y=y,
##                          f=fields: s.schemaDrop_Dropdown(t, f, x, y) )

      menu.AppendSeparator()
      wid = wxNewId()
      menu.Append(wid, _("Create Block (no fields)"))
      EVT_MENU(menu, wid,  lambda event, s=self, t=table,
                                f=fields: s.schemaDrop_Block(t, f, select=1) )
      wid = wxNewId()
      menu.Append(wid, _("Create Data Source (no bound block)"))
      EVT_MENU(menu, wid,  lambda event, s=self, t=table,
                                f=fields: s.schemaDrop_Datasource(t, f, select=1) )

      # Show the popup menu
      self.editor.panel.PopupMenuXY(menu, x, y)


  #
  # User requested we add fields to current block
  #
  def schemaDrop_Add(self, table, fields, block, x, y):
    y = int(y / self.editor.gridHeight)
    x = int(x / self.editor.gridWidth)
    maxWidth = x
    page = self.editor.page
    instance = self.editor.instance
    selection = []
    for f in fields:
      try:
        label=f['label'] + ':'
      except KeyError:
        label=f['name'].replace('_',' ').capitalize()+':'

      # Create the field
      try:
        width = min(f['length'],30)
      except KeyError:
        width = 10

      fattr = {'name': instance.getUniqueName('fld' + f['name'].capitalize()),
               'field':f['name'],
               'typecast':f['datatype']}

      try:
        fattr['required'] = f['required']
      except KeyError:
        pass

      try:
        defaulttype = f['defaulttype']
        defaultval = f['defaultval']
      except KeyError:
        defaulttype = None

      if defaulttype == 'constant':
        fattr['default'] = defaultval

      field = instance.incubator.createObject(
                instance.rootObject,
                'field',
                block,
                attributes=fattr,
                select=0)

      # Create any pre-insert triggers
      triggertext = ""
      if defaulttype == 'sequence':
        triggertext = "\n# Set default value\n" \
                    + "if self.isEmpty():\n" \
                    + "  self.autofillBySequence('%s')\n" % defaultval
      elif defaulttype == 'system' and defaultval == 'timestamp':
        triggertext = "\n# Set default value\n" \
                    + "if self.isEmpty():\n" \
                    + "  self.value = %s.extensions.getTimeStamp()\n" \
                      % block.datasource

      if triggertext:
        instance.incubator.createObject(
                    instance.rootObject,
                    'trigger',
                    field,
                    attributes = {
                      '_content_': triggertext,
                      'type': 'PRE-INSERT',
                      'name': '%s_PreInsert' % field.name },
                    select=0)



      # Create the labels
      selection.append(instance.incubator.createObject(
                instance.rootObject,
                'label',
                page,
                attributes={'name': instance.getUniqueName('lbl%s' % f['name'].capitalize()),
                            'text': label,
                            'Char:x': x,
                            'Char:y': y,
                            'Char:width': len(label)},
                select=0))

      # Create the entry
      selection.append(instance.incubator.createObject(
                instance.rootObject,
                'entry',
                page,
                attributes={'name': instance.getUniqueName('ntry%s' % f['name'].capitalize()),
                            'field': field.name,
                            'block': block.name,
                            'Char:x': x + len(label) + 1,
                            'Char:y': y,
                            'Char:width': width},
                select=0))

      maxWidth = max(maxWidth, x + len(label) + width + 2)
      y += 1

    # Adjust form height if necessary
    if y > instance.rootObject._layout.Char__height or \
       maxWidth > instance.rootObject._layout.Char__width:

      old = {}
      new = {}

      if y > instance.rootObject._layout.Char__height:
        old['Char:height'] = instance.rootObject._layout.Char__height
        new['Char:height'] = y
        instance.rootObject._layout.Char__height = y

      if maxWidth > instance.rootObject._layout.Char__width:
        old['Char:width'] = instance.rootObject._layout.Char__width
        new['Char:width'] = maxWidth
        instance.rootObject._layout.Char__width = maxWidth

      instance.dispatchEvent('ObjectModified',
             object=instance.rootObject._layout,
             old=old,
             new=new,
             originator=__name__)

    # Select the new block
    if selection:
      o = selection[0]
    else:
      o = block

    instance.dispatchEvent('ObjectSelected', object=o,
                           originator=__name__,
                           selection=selection)

    # Move the focus onto our grid panel
    self.editor.panel.SetFocus()

  #
  # User requested we create a new block and add fields
  #
  def schemaDrop_Create(self, table, fields, x, y):
    block = self.schemaDrop_Block(table, fields)
    self.schemaDrop_Add(table, fields, block, x, y)


  #
  # user requested we only create a new block
  #
  def schemaDrop_Block(self, table, fields, select=0):
    instance = self.editor.instance
    datasource = self.schemaDrop_Datasource(table, fields)
    o = instance.incubator.createObject(
            instance.rootObject,
            'block',
            instance.rootObject._logic,
            attributes={'name': instance.getUniqueName('blk%s'%table['name'].capitalize()),
                        'datasource':datasource.name},
            select=0)

    # Select the new block
    if select:
      instance.dispatchEvent('ObjectSelected', object=o, originator=__name__)

    return o

  #
  # User requested we only create a new datasource
  #
  def schemaDrop_Datasource(self, table, fields, attrs={}, select=0):
    instance = self.editor.instance
    attrs.update({'name': instance.getUniqueName('dts%s'%table['name'].capitalize()),
                        'connection':table['connection'],
                        'table': table['name']})

    # Add the primary key(s) if applicable
    try:
      if table['primarykey']:
        attrs['primarykey'] = string.join(table['primarykey'],',')
    except KeyError:
      pass

    o = instance.incubator.createObject(
            instance.rootObject,
            'datasource',
            instance.rootObject,
            attributes=attrs,
            select=0)

    # Select the new datasource
    if select:
      instance.dispatchEvent('ObjectSelected', object=o, originator=__name__)

    return o


  #
  # User requested we create a dropdown
  #
  def schemaDrop_Dropdown(self, table, fields, x, y):
    if not self.editor.block:
      print "No blocks in form" # TODO: Better feedback
      return

    datasource = self.schemaDrop_Datasource(table, fields, {'prequery': 1})
    block = self.editor.block

    fkid = None
    fkdescr = None
    try:
      pk = table['primarykey'] or []
    except KeyError:
      pk = []

    for field in fields:
      if field['name'] in pk:
        fkid = field
        break

    # TODO: Finish me!





