#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# Utils.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from gnue.common.apps import GDebug


#
# Convenience function for inplace sorting
#
def order(*p):
  rv = list(p) # Convert the tuple to a list
  rv.sort()
  return rv



def calcRelPos(xsource, ysource=None, absx=None, absy=None, dx=None, dy=None):
  if ysource == None:
    ysource = xsource
  x = xsource.GetPosition().x
  y = ysource.GetPosition().y
  w = xsource.GetSize().width
  h = ysource.GetSize().height

  if absx != None:
    x = absx
  else:
    x = x + w + dx

  if absy != None:
    y = absy
  else:
    y = y + h + dy

  return wxPoint (x,y)



#
#
#
class MoveDropSource(wxDropSource):

  def __init__(self, handler, *args, **parms):
    self.__handler = handler
    wxDropSource.__init__(self, *args, **parms)

  def GiveFeedback(self, effect, scrolling=0):
    return 0

