#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# forms/wizards/AddButton.py
#
# DESCRIPTION:
# Adds a Button to the form
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string

#
# Steps
#
# 0. Get Title             Finish
#


class AddButtonWizard(FormPrePositioningTemplate):


  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def StartWithPositioning(self, root, current,
           x=0, y=0, width=10, height=1):
    self.form = root
    self.current = current
    self.x = x
    self.y = y
    self.width = width
    self.height = height



  ###############
  #
  # Return the markup for a specific Button
  #
  def GetStep(self, step):

    #
    # Step #0 / Get Name
    #
    if step == '0':

      content = [WizardText('This will insert a new Button.'),
                 WizardInput('name',label='Object Name:',required=1,size=20),
                 WizardInput('label',label='Button Label:',required=1,size=20),
                 WizardInput('action', label='Source:', required=1,
                                           maxSelections=1,
                                           set=(
                                  ('t:trigger','Execute a custom trigger'),
                                  ('b:nextRecord','Move to the Next Record'),
                                  ('b:prevRecord','Move to the Previous Record'),
                                  ('b:firstRecord','Move to the First Record'),
                                  ('b:lastRecord','Move to the Last Record'),
                                  ('b:newRecord','Insert a New Record'),
                                  ('b:deleteRecord','Delete the Current Record'),
                                  ('f2:runForm','Call another form'),
                                  ('f:enterQuery','Enter a Query'),
                                  ('f:executeQuery','Execute a Query'),
                                  ('f:commit','Perform a Commit'),
                                  ('f:rollback','Perform a Rollback'))

)
                 ]


      return   { 'title': 'Add Button',
                 'content': content,
                 'prev': None,
                 'next': None }



  ###############
  #
  # Verify contents of current step
  # Return None if no problems, otherwise
  # return a tuple of error message strings
  #
  def ValidateStep(self, stepCode):

    # The Simple wizard uses basic "required"
    # settings in the Button markup, so doesn't
    # need any special validation.
    return None



  ###############
  #
  # We have all the data, so generate our form. This
  # is called after the user clicks the "Finish" button.
  # No more user input is allowed at this point.
  #
  def Finalize(self):

    name = self.GetUniqueName(self.variables['name'] or 'Button1')
    label = self.variables['label'] or name

    attrs = {'name': name,
             'label': label,
             'Char:x': self.x,
             'Char:y': self.y,
             'Char:width': max(self.width, len(label) + 2),
             'Char:height': self.height or 1}

    button = self.AddElement('button', self.current['page'], attrs)

    action, info = string.split(self.variables['action'],':')

    if action == 'b':
      block = self.current['block']
      blockName = block.name


    code = triggerTemplates[action] % locals()

    trigger = self.AddElement('trigger',
                              button,
                              attributes = {
                                'name': '%sTrigger' % name,
                                'type':'On-Action' },
                              content = code)

    return 1



triggerTemplates = {
't': """\
##
## [Button On-Action Trigger]
##

# Your code goes here
pass
""",

'b': """\
##
## [Button On-Action Trigger]
##

# Perform a block-level %(info)s
%(blockName)s.%(info)s()
""",

'f': """\
##
## [Button On-Action Trigger]
##

# Perform a form-level %(info)s
form.%(info)s()
""",

'f2': """\
##
## [Button On-Action Trigger]
##

#
# Call a new form
#
location = "REPLACEME.gfd"  # Location of the form
parameters = {}             # Parameters to pass to the form

form.%(info)s(location, parameters)
"""

}


############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    # Unique name for this wizard
    'BaseID' : 'AddButton',
    'Name' : 'Add Button',

    'BaseClass' : AddButtonWizard,
    'Description' : _('Inserts a button bound to an event'),
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,

    # Add to the menu
    'MenuLocation' : ('Insert',  _('Button'), 401.5)
}


