#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# navigator/Instance.py
#
# DESCRIPTION:
# Creates a "Navigator" instance
#
# NOTES:
#

from gnue.designer.navigator import properties as navProperties
from gnue.designer.base.Instance import BaseInstance
from Incubator import Incubator

# Tool support...
from LayoutEditor import LayoutEditor
##from gnue.designer.TreeView import TreeView
##from gnue.designer.PropertyEditor import PropertyToolFrame
##from gnue.designer.TriggerEditor import TriggerEditor
##from gnue.designer.DataSourceEditor import DataSourceEditor
##from gnue.designer.SchemaViewer import SchemaViewer

##from PopupMenu import ObjectMenu

from gnue.navigator import GNParser, GNObjects


class Instance(BaseInstance):

  def __init__(self, app, *args, **params):
   self.incubator = Incubator(self)
   self.properties = navProperties

   BaseInstance.__init__(self, app, *args, **params)


  def loadBuffer(self, buffer):
    object = GNParser.loadProcesses (buffer, initialize=0)
##    object.name = 'processes'
    return object


  def loadEmpty(self, style=None):
    object = GNObjects.GNProcesses()
    object.title = "Untitled Process"
    return object


  def inventoryObject(self, object):
    pass


  def createVisualEditor(self):
    return LayoutEditor(self, self.rootObject, self)


  def createTools(self):
    pass
##    self.addTool('propertyEditor','Property Inspector', PropertyEditor)
##    self.addToolol('treeEditor','Object Navigator', TreeView)
##    self.addTool('triggerEditor','Event Editor', TriggerEditor)
##    self.addTool('datasourceEditor','Data Source Editor', DataSourceEditor)
##    self.addTool('schemaViewer','Schema Navigator', SchemaViewer)

  def createWizards(self):
    self.loadWizards(wizards)

  def preSave(self):
    pass



