#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: Config.py 7049 2005-02-21 11:00:07Z kilo $

"""
Valid configuration options for designer
(appears under [designer] section in gnue.conf)
"""

from gnue.common.formatting import GTypecast

ConfigOptions = (
  { 'Name'       : 'AutoConnect',
    'Type'       : 'Setting',
    'Comment'    : 'Automatically log in to needed connections to do schema.',
    'Description': 'Automatically log in to needed connections to do schema.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'ColorizeCode',
    'Type'       : 'Setting',
    'Comment'    : 'Use syntax highlighting in the trigger editor.',
    'Description': 'Use syntax highlighting in the trigger editor.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'ForceSimpleEditor',
    'Type'       : 'Setting',
    'Comment'    : 'Use the basic editor for triggers.',
    'Description': 'Use the basic editor for triggers.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : False },

  { 'Name'       : 'BorderPercentage',
    'Type'       : 'Setting',
    'Comment'    : 'Fudge factor for altering widget size',
    'Description': 'Fudge factor for altering widget size',
    'Typecast'   : GTypecast.number,
    'Default'    : 100.0 },

  { 'Name'       : 'TextPercentage',
    'Type'       : 'Setting',
    'Comment'    : 'Fudge factor for altering text size',
    'Description': 'Fudge factor for altering text size',
    'Typecast'   : GTypecast.number,
    'Default'    : 100.0 },

  #
  # Toolbar Icons
  #
  { 'Name'       : 'tb_insert',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Insert" toolbar icon (PNG format)',
    'Description': 'Location of "Insert" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : '%(prefix)s/shared/images/designer/tb_new.png' },
  { 'Name'       : 'tb_delete',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Delete" toolbar icon (PNG format)',
    'Description': 'Location of "Delete" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : '%(prefix)s/shared/images/designer/tb_trash.png' },

)
