#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
"""
A pyQT based user interface driver for GNUe forms.
"""
# NOTES:
#

import sys
import string

from gnue.forms.uidrivers._base import Exceptions

try:
  from qt import *
except ImportError:
  raise Exceptions.DriverNotSupported, _("The GNUe-Forms QT3 driver requires PyQT.")

from gnue.common import events
from gnue.common.apps import GConfig
from gnue.common.utils.TextUtils import lineWrap

from gnue.forms import VERSION
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit

from gnue.forms.uidrivers.qt.QTApp import *
from gnue.forms.uidrivers.qt.QTSplashScreen import *
from gnue.forms.uidrivers.qt.widgets._base  import *
from gnue.forms.uidrivers.qt.common import _eventObjToQtWindow, setWidgetBaseFont
from common import *



#
# GFUserInterface
#
# The public interface to the User Interface
# All UIs must provide this class
#
class GFUserInterface(commonToolkit.GFUserInterface):

  def initialize(self):

    self._disabledColour = None

    self._qtapp = getQtApp()

    fdb = QFontDatabase()

    #
    # TODO: Wouldn't it be nice if this actually picked a font
    # TODO: that didn't suck.
    #
    #fixedFont = ""
    #for family in fdb.families():
    #  for style in fdb.styles(family):
    #    if fdb.isFixedPitch(family,style):
    #      fixedFont = fdb.font(family,style,int(gConfigForms('pointSize')))
    #      break
    #  if fixedFont != "":
    #    break
    #font = fixedFont

    font = QFont("Courier 10 Pitch", int(gConfigForms('pointSize')))
    font.setFixedPitch(True)

    #info = QFontInfo(font)
    #print "DATA:", info.family(),info.fixedPitch()
    font.setPointSize(int(gConfigForms('pointSize')))
    setWidgetBaseFont(font)

    #
    # SplashScreen
    #
    if not self._disableSplash:
      self.splash = QTSplashScreen()

    fm = QFontMetrics(font)
    # TODO: Making some assumptions here!!
    maxWidth=0
    checkchars = string.printable
    for letter in checkchars:
      width = fm.width("W")
      maxWidth = max(maxWidth,width)

    print "Max Width = ", maxWidth, fm.width("i")
    #maxWidth=fm.width("W")
    maxHeight = fm.height()
    maxDescent = fm.descent()
    maxLeading = fm.leading()

    self.textWidth    = int(maxWidth+maxLeading)  # The pixel width of text inside a widget
    self.textHeight   = int(maxHeight+maxDescent) # The pixel height of text inside a widget
    self.widgetWidth  = self.textWidth            # The pixel width of a 1 char widget (for things like buttons)
    self.widgetHeight = self.textHeight + 4       # The pixel height of a 1 char widget (for things like buttons)



  #############################################################################
  #
  # Private UIBase support functions
  #
  # Called in UIbase functions to perform UI interaction with this specific
  # widget set.
  #

  #
  # _exit
  #
  # Tells the application to close it's main window
  #
  def _exit(self, formName):
    exitApp = 1
    for child in self._children:
      if child._form.name == formName:
        child.mainWindow.hide()

      exitApp = exitApp and not child.mainWindow.isVisible()

    if exitApp:
      for child in self._children:
        child.mainWindow.close(1)



  #############################################################################
  #
  # Incoming Event Processors
  #
  # Processes the incoming events from other objects
  # From here down should be nothing but eventListeners listed

  #
  # mainLoop
  #
  # The primary loop of the user interface.  Called once the UI is
  # fully activated
  #
  def mainLoop(self):
    self._qtapp.exec_loop()


  def _beep(self, event):
    self._qtapp.bell()

  #
  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  #
  def beginWait (self, event):
    self._qtapp.setOverrideCursor(QCursor(self._qtapp.WaitCursor))

  #
  # Called whenever forms leaves a "wait" state
  #
  def endWait (self, event):
    self._qtapp.restoreOverrideCursor()


  #
  # Clipboard routines
  #
  # If a particular UI has a system-wide clipboard,
  # these methods should be overridden to use that
  # clipboard.
  #
  def getClipboardContents(self, event):
    event.__result__ = str(self._qtapp.clipboard().text())


  def setClipboardContents(self, event):
    self._qtapp.clipboard().setText(event.text)


  #############################################################################
  #
  # Internal Event Processors
  #
  # Processes the events from the widget set
  #

  #
  # closeTrap
  #
  # intercepts the applications closure and generates an event to the form requesting
  # closure.  Allows the form to control closure.  If the form approves it'll send
  # back an event closing the application
  #`
  def closeTrap(self,event):
    if event.CanVeto():
      self.dispatchEvent('requestEXIT',_form=self._form)
    else:
      object = _eventObjToQtWindow(event)
      object.Destroy()
      # wxExit() TODO: Try and work this into navigator or here if it still hangs

