#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
#
# FILE:
# GFImage.py
#
# DESCRIPTION:
"""
Logical image support
"""
# NOTES:
#
# HISTORY:
# Copyright (c) 2000 Free Software Foundation
#

from GFTabStop import GFTabStop
from GFTabStop import GFTabStop
from gnue.forms.input import displayHandlers
#
#GFLabel
#
class GFImage(GFTabStop):
  def __init__(self, parent=None, value=None):
    GFTabStop.__init__(self, parent, 'GFImage')

    # Default attributes (these may be replaced by parser)
    self.type = "URL"
    self.Char__height = int(gConfigForms('widgetHeight'))

    # Runtime Variables
    self._inits = [self.initialize]

#    self.isNavigable = GFTabStop.isNavigable

  def _buildObject(self):
    if not hasattr(self, 'rows') and hasattr(self,'visibleCount'):
      self.rows = self.visibleCount
      del self.visibleCount
    return GFTabStop._buildObject(self)

  def setValue(self, value):
    if not self._value:
      GFTabStop.setValue(self,value)

  #
  # Routines called during a phaseInit
  #
  def initialize(self):
    #
    # Find parents/relatives
    #

    # ...Block
    try:
      self._block = block = self.findParentOfType('GFForm')._logic._blockMap[self.block]
      block._entryList.append(self)
    except KeyError:
      raise "Image references non-existent block '%s'" % self.block

    # ...Field
    try:
      self._field = field = block._fieldMap[self.field]
      field._entryList.append(self)
    except KeyError:
      raise "Image references non-existent field '%s'" % self.field

    # ...Page
    self._page = self.findParentOfType('GFPage')
    self._page._entryList.append(self)

    self._form = self._block._form

    self._navigable = False # self.navigable

    # print "Controller", self._form._instance.eventController
    # print "Sub Handler", self.subEventHandler
    # print displayHandlers.Image
    self._displayHandler = displayHandlers.factory(self,
                              self._form._instance.eventController,
                              self.subEventHandler,None, None)

  # TODO: Conversion:  Does this belong here or not?
  def getValue(self, *args, **parms):
    return self._field.getValue(*args, **parms)



  def isNavigable(self, mode):
    # TODO: Check for read-only, etc
    return GFTabStop.isNavigable(self, mode)

