#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
#
# DESCRIPTION: 
"""
"""

__all__ = [
      "Checkbox",
      "Component",
      "DateTime",
      "Dropdown",
      "Image",
      "Listbox",
      "Numeric",
      "Password",
      "Text",
       ]

for module in __all__:
  exec "from gnue.forms.input.displayHandlers.%s import %s" % (module, module)

def factory(entry, eventHandler, subEventHandler, displayMask, inputMask):
  """
  Function to act as a display handler factory.
  
  @return An instance of a display handler that is appropriate for the
          entry type passed in.
  """
  classConstructors = {'checkbox':Checkbox,
                       'date':    DateTime,
                       'dropdown': Dropdown,
                       'listbox': Listbox,
                       'password':Password,
                       'number':  Numeric,
                       'image' : Image
                      }
  
  if entry._type == 'GFImage':
    # Images don't need input masks so just return the image now
    return Image(entry, eventHandler, subEventHandler)
  elif entry._field.typecast == 'date':
    key = 'date'
  elif entry._field.typecast == 'number':
    key = 'number'
  else:
    key = entry.style
    
  assert gDebug(6, "Creating display handler for entry key %s" % key)
  try:
    constructor = classConstructors[key]
  except KeyError:
    constructor = Text
  
  
  return constructor(entry, eventHandler, subEventHandler,displayMask, inputMask )
