# GNU Enterprise Forms - GTK UI Driver - Menubar widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: MenuBar.py 7936 2005-09-21 09:04:24Z johannes $

import gtk

from gnue.forms.uidrivers._commonGuiToolkit.MenuBar import MenuBar as Base

  
# =============================================================================
# This class implements the menu bar widget for GTK
# =============================================================================

class MenuBar (Base):

  # ---------------------------------------------------------------------------
  # Create the menu
  # ---------------------------------------------------------------------------

  def init (self):
    self.handleBox = gtk.HandleBox ()
    self.menu = gtk.MenuBar ()
    self.handleBox.add (self.menu)
    self.menu.show ()

    self.container.content_table.attach (self.handleBox,
                                     # X direction           Y direction
                                       0, 1,                      0, 1,
                                       gtk.EXPAND | gtk.FILL,     0,
                                       0,                         0)
    return self.menu


  # ---------------------------------------------------------------------------
  # Make sure to have a correct label
  # ---------------------------------------------------------------------------

  def correctLabel (self, label):
    return label.replace ('&', '_')
    
  # ---------------------------------------------------------------------------
  # Add a (sub)menu
  # ---------------------------------------------------------------------------

  def addMenu (self, name, parent):
    menuitem = gtk.MenuItem (self.correctLabel (name))
    menu = gtk.Menu ()
    menuitem.set_submenu (menu)
    parent.add (menuitem)
    return menu
  

  # ---------------------------------------------------------------------------
  # Add a menu item (action)
  # ---------------------------------------------------------------------------

  def addAction (self, name, parent, userAction):
    label   = name
    hotkey  = userAction.getHotKeyTuple ()
    iconloc = userAction.getIconLocation (size = "16x16")

    item = gtk.ImageMenuItem (self.correctLabel (label))

    if hotkey is not None:
      (base, shift, ctrl, meta) = hotkey
      mod = 0
      if shift: mod = mod | gtk.gdk.SHIFT_MASK
      if ctrl:  mod = mod | gtk.gdk.CONTROL_MASK
      if meta:  mod = mod | gtk.gdk.MOD1_MASK

      item.add_accelerator ('activate', self.container.accelGroup, base, mod,
                            gtk.ACCEL_VISIBLE)


    parent.add (item)

    item.connect ('activate', self._menuHandler, userAction)
    item.connect ('select', self._selectHandler, userAction)
    item.connect ('deselect', self._deselectHandler, userAction)

    # Set the action icon if available
    if iconloc:
      icon = gtk.Image ()
      icon.set_from_file (iconloc)

      item.set_image (icon)

    return item


  # ---------------------------------------------------------------------------
  # Handle the activate-signal of menu items
  # ---------------------------------------------------------------------------

  def _menuHandler (self, menuItem, userAction):

    event = "request%s" % userAction.event
    self.driver.dispatchEvent (event, _form = self.form)


  # ---------------------------------------------------------------------------
  # Display the tooltip in the statusbar if a menu item get's selected
  # ---------------------------------------------------------------------------

  def _selectHandler (self, menuItem, userAction):

    self.container._setStatusBar (userAction.description, None, None, None,
                                  None, None, None, procMsg = False)


  # ---------------------------------------------------------------------------
  # Clear the tooltip in the statusbar if a menu item get's deselected
  # ---------------------------------------------------------------------------

  def _deselectHandler (self, menuItem, userAction):

    self.container._setStatusBar ('', None, None, None, None, None, None,
        procMsg = False)


  # ---------------------------------------------------------------------------
  # Add a separator
  # ---------------------------------------------------------------------------

  def addSeparator (self, parent):
    item = gtk.SeparatorMenuItem ()
    parent.add (item)
    

  # ---------------------------------------------------------------------------
  # Enable a menu item
  # ---------------------------------------------------------------------------

  def enableItem (self, item):
    item.set_sensitive (1)
  

  # ---------------------------------------------------------------------------
  # Disable a menu item
  # ---------------------------------------------------------------------------

  def disableItem (self, item):
    item.set_sensitive (0)
