# GNU Enterprise Forms - GTK UI Driver - Splash screen
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: SplashScreen.py 7936 2005-09-21 09:04:24Z johannes $

import gtk
import gobject
import os.path

from gnue.common.apps import GConfig

# =============================================================================
# A splash screen window
# =============================================================================

class UISplashScreen (gtk.Window):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self):

    gtk.Window.__init__ (self, True)

    # not the best, but working decision
    self.set_resizable (True)
    self.resize (525, 200)
    self.set_modal (1)
    self.set_position (1) # for center

    images_dir = GConfig.getInstalledBase ('forms_images', 'common_images')

    if os.path.isabs (gConfigForms ('splashScreenPNG')):
      bitmapFile = gConfigForms ('splashScreenPNG')
    else:
      bitmapFile = os.path.join (images_dir, gConfigForms ('splashScreenPNG'))

    img = gtk.Image ()
    img.set_from_file (bitmapFile)
    box = gtk.VBox ()
    self.add (box)
    box.add (img)
    box.add (gtk.Label ('GNU Enterprise'))
    box.add (gtk.Label ("Protected by GNU General Public Licence 2.0"))


  # ---------------------------------------------------------------------------
  # Show the window
  # ---------------------------------------------------------------------------

  def Show (self):
    """
    Show the splash screen window and add a timeout of 1.5 seconds.
    """

    gobject.timeout_add (1500, self.Destroy)
    self.show_all ()
    self.show_now ()


  # ---------------------------------------------------------------------------
  # Destroy (and hide) the window
  # ---------------------------------------------------------------------------

  def Destroy (self):
    """
    Destroy (and hide) the splash screen. This function get's called
    automatically 1.5 seconds after Show () has been called.
    """

    self.destroy ()
