# GNU Enterprise Forms - GTK UI Driver - Login Handler
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: UILoginHandler.py 7806 2005-08-09 17:21:10Z reinhard $

import os.path

from gnue.common.apps import GConfig
from gnue.common.datasources import GLoginHandler
from gnue.forms.uidrivers.gtk2 import dialogs

# =============================================================================
# This class implements a login handler for GTK2 
# =============================================================================

class UILoginHandler (GLoginHandler.LoginHandler):

  # ---------------------------------------------------------------------------
  # Create an instance of an InputDialog and return it's result
  # ---------------------------------------------------------------------------

  def _askLogin_ (self, title, fields):

    lfields = fields [:]
    if lfields [0][2] != 'image':
      imageFile = gConfigForms('loginPNG')
      if not os.path.exists (imageFile):
        imageFile = os.path.join (os.path.normpath ( \
            GConfig.getInstalledBase ('forms_images', 'common_images')),
            gConfigForms ('loginPNG'))

      if os.path.exists (imageFile):
        lfields.insert (0, (None, imageFile, 'image', None, None, []))

    dlg = dialogs.InputDialog (title, lfields)

    try:
      dlg.run ()
      result = dlg.inputData
    finally:
      dlg.destroy ()

    return result
