#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
#
# FILE:
# GFParameters.py
#
# DESCRIPTION:
"""
Parameter support
"""
# NOTES:
#

from GFObj import GFObj
from gnue.common.datasources import GConditions
import string

#
#
#
class GFParameter(GFObj):
  def __init__(self, parent=None):
    GFObj.__init__(self, parent, 'GFParameter')


  def _buildObject(self):
    self._name = string.lower(self.name)
    return GFObj._buildObject(self)

#
#
#
class GFCParam(GConditions.GCParam):

  def __init__(self, parent=None):
    GConditions.GCParam.__init__(self, parent)
    self._inits.append(self.initialize)
    self._type = "GFCParam"


  def initialize(self):
    self._name = string.lower(self.name)
    self._form = self.findParentOfType('GFForm')
    for param in self._form._children:
      if isinstance(param, GFParameter) and param._name == self._name:
        self._parameter = param
        break


  def getValue(self):
      val = self._form.getParameter(self._name)
      if val is None:
        return ""
      elif self._parameter.type == 'number':
        return float(val)
      else:
        return "%s" % val

