#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

import atexit
#import curses
from gnue.common.cursing import *


_SIO = None

def GetSIO():
  global _SIO
  if not _SIO:
    _SIO = sio()
    _SIO.BeginScreenAccess()
    atexit.register(_restore)
  return _SIO

def _restore(*args, **parms):
  # Set everything back to normal
  try:
#    _SIO.keypad(0)
    curses.echo()
    curses.nocbreak()
    curses.endwin()          # Terminate curses
  except:
    pass





