#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# SplashScreen.py
#
# DESCRIPTION:
# A GTK2 based splash screen
#
# NOTES:
#

import os.path
import gtk
from gnue.common.apps import GConfig
from gnue.forms import VERSION

class UISplashScreen(gtk.Window):
  # is there a default gtk2 splashscreen to inherit?
  def __init__(self):
    images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'
    if os.path.isabs(gConfigForms('splashScreenPNG')):
      bitmapFile=gConfigForms('splashScreenPNG')
    else:
      bitmapFile=images_dir+gConfigForms('splashScreenPNG')

      
    gtk.Window.__init__(self,gtk.TRUE)
    # not the best, but working decision
    self.connect('destroy', lambda win: self.hide())
    self.set_resizable(gtk.TRUE)
    self.resize(525,200)
    self.set_modal(1)
    self.set_position(1) # for center
    img = gtk.Image()
    img.set_from_file(images_dir + gConfigForms('splashScreenPNG'))
    box=gtk.VBox()
    self.add(box)
    box.add(img)    
    box.add(gtk.Label('GNU Enterprise'))
    box.add(gtk.Label("Protected by GNU General Public Licence 2.0"))
    # use drawingarea instead, see:
    # http://www.moeraki.com/pygtktutorial/pygtk2tutorial/sec-DrawingMethods.html
    # Make the splash text print white
    #self.SetForegroundColour(wxColour(0xFF, 0xFF, 0xFF))
    #self.SetFont(wxFont(20,wxSWISS,wxNORMAL,wxBOLD))

    #text = _("GNU Enterprise Forms")
    #twidth,theight = self.GetTextExtent(text)
    #wxStaticText(parent=self, id=-1, label=str(text),
    #             size=wxSize(swidth,theight),pos=wxPoint(1,1),style=wxALIGN_CENTRE)

    #self.SetFont(wxFont(10,wxSWISS,wxNORMAL,wxBOLD))
    
    #text = _("Version %s") % VERSION
    #twidth,theight = self.GetTextExtent(text)
    #wxStaticText(parent=self, id=-1, label=str(text),
    #             size=wxSize(swidth,theight), pos=wxPoint(1,25),style=wxALIGN_CENTRE)

    #text = "(c)2000-2002 Free Software Foundation"
    #twidth,theight = self.GetTextExtent(text)
    #wxStaticText(self, -1, str(text),
    #             wxPoint(1,50),wxSize(swidth,theight),wxALIGN_CENTRE)

    #text = _("Protected by GNU General Public Licence 2.0")
    #wxStaticText(self, -1, str(text),
    #             wxPoint(1,sheight-(theight+10)),wxSize(swidth-5,theight),wxALIGN_RIGHT)

    #self.CenterOnScreen()

  def Show(self):
    gtk.timeout_add(1500,lambda splash: splash.destroy(),self)
    self.show_all()
    self.show_now()

  def onCloseSplash(self):
    pass
