#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/UIdriver.py
#
# DESCRIPTION:
# A gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import sys
import string

from gnue.forms.uidrivers._base import Exceptions

try:
  import pygtk
  pygtk.require('2.0')

  import gtk
  import pango

  ## check if we really imported gtk 2.0
  if not hasattr(gtk,"keysyms"):
    print _("Import error: You need pygtk 2.0 to use the gtk2 user" +\
          " interface driver.")
    print "You are actually using gtk %s.%s.%s ."% gtk.gtk_version + \
        "and pygtk %s.%s.%s ."% gtk.pygtk_version
    raise ImportError

except ImportError:
  raise Exceptions.DriverNotSupported, _("The GNUe-Forms GTK driver requires PyGTK and GTK 2.x.")


from gnue.common import events
from gnue.common.apps import GDebug
from gnue.common.apps import GConfig
from gnue.common.utils.TextUtils import lineWrap


from gnue.forms.GFForm import *

from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit

from gnue.forms.uidrivers.gtk2.GFApp import *
from gnue.forms.uidrivers.gtk2.SplashScreen import *
from gnue.forms.uidrivers.gtk2.widgets._base  import *
from gnue.forms.uidrivers.gtk2.common import PANGO_SCALE


#
# GFUserInterface
#
# The public interface to the User Interface
# All UIs must provide this class
#
class GFUserInterface(commonToolkit.GFUserInterface):

  _WidgetToGFObj = {}
  _WidgetToUIObj = {}

  def initialize(self):

    # self._disabledColour = gtk.gdk.color_parse("light_grey")

    ################################################################
    # GTK Specifics
    ################################################################

    self.app = getApp()

    #
    # SplashScreen
    #
    if not self._disableSplash:
      self.splash = UISplashScreen()
      self.splash.Show()
      gtk.timeout_add(1500,lambda splash: splash.destroy(),self.splash)

    #
    # Set default form font
    #

    if gConfigForms('fixedWidthFont'):
      fontname = 'monospace %s' % gConfigForms('pointSize')
    else:
      fontname = 'bitstream vera %s' % gConfigForms('pointSize')

    self.mono_font = pango.FontDescription(fontname)

    #
    # Create a dummy window used to compute sizes
    #
    dummyWindow = gtk.Window()
    dummyWindow.modify_font(self.mono_font)

    p_c=dummyWindow.get_pango_context()
    p_m=p_c.get_metrics(self.mono_font,
                        pango.pango_language_from_string('english'))

    # The pixel width of text inside a widget
    self.textWidth    = int (p_m.get_approximate_char_width() / PANGO_SCALE)

    # The pixel height of text inside a widget
    self.textHeight   = int (( p_m.get_ascent() + p_m.get_descent()) \
                             / PANGO_SCALE * 1.3)

    # The pixel width of a 1 char widget (for things like buttons)
    self.widgetWidth  = self.textWidth

    # The pixel height of a 1 char widget (for things like buttons)
    self.widgetHeight = self.textHeight + 3

    #
    # Close dummy window so app doesn't hang when all other windows closed
    #
    dummyWindow.destroy()


  #############################################################################
  #
  # Private UIBase support functions
  #
  # Called in UIbase functions to perform UI interaction with this specific
  # widget set.
  #

  #
  # _exit
  #
  # Tells the application to close it's main window
  #
  def _exit(self,formName):
    exitApp = 1
    for child in self._children:
      if child._form.name == formName:
        child.mainWindow.hide()
        child._visible=0

      exitApp = exitApp and not child._visible

    if exitApp:
      for child in self._children:
        child.mainWindow.destroy()
      self.app.quit()

  def _beep(self):
    pass

  #############################################################################
  #
  # Incoming Event Processors
  #
  # Processes the incoming events from other objects
  # From here down should be nothing but eventListeners listed

  #
  # mainLoop
  #
  # The primary loop of the user interface.  Called once the UI is
  # fully activated (multiple loops are simulated by GFApp)
  #
  def mainLoop(self):
    self.app.mainLoop()


  #
  # formAlert
  #
  # Rings a bell and alters the statusbar to display
  # a line of text
  #
  def formAlert(self, event):
    ui = self._gfObjToUIWidget[event._form]
    ui.statusBar1.push(ui.statusBar1.get_context_id("tip"),unicode(event.data))

  #
  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  #
  def beginWait (self, event):
    # TODO: get _form.mainwindow from event
    #cursor = gtk.cursor_new(GDK.WATCH)
    #gdkwin = b.get_window()
    #gdkwin.set_cursor(watch)
    GDebug.printMesg(2, "i am in beginWait")

  #
  # Called whenever forms leaves a "wait" state
  #
  def endWait (self, event):
    # self.cursor= gtk.gdk.Cursor(gtk.gdk.MOUSE)
    GDebug.printMesg(2, "i am in endWait")


  #
  # Clipboard routines
  #
  # If a particular UI has a system-wide clipboard,
  # these methods should be overridden to use that
  # clipboard.
  #
  def getClipboardContents(self, event):
    return
    if wxTheClipboard.Open():
      data = wxTextDataObject()
      success = wxTheClipboard.GetData(data)
      wxTheClipboard.Close()
    else:
      success = 0
      GDebug.printMesg(5,'Unable to open clipboard for read')

    if success:
      value = data.GetText()
    else:
      GDebug.printMesg(5,'Unable to obtain clipboard contents. Defaulting to Empty.')
      value = None

    GDebug.printMesg(5, "Getting clipboard value '%s'" % value)
    event.__result__ = value


  def setClipboardContents(self, event):
    return
    GDebug.printMesg(5,"Setting clipboard '%s'" % event.text)

    if wxTheClipboard.Open():
      value = wxTheClipboard.SetData(wxTextDataObject(event.text))
      GDebug.printMesg(10,"Set Clipboard Status: %s" % value)
      wxTheClipboard.Close()

    else:
      GDebug.printMesg(5,'Unable to open clipboard for write')
