#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/_base.py
#
# DESCRIPTION:
# Part of a gtk2 based user interface driver for GNUe forms: Base Widget
#
# NOTES:
#

import gtk

from gnue.common import events
from types import UnicodeType
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.widgets._base import UIWidget
from gnue.forms.uidrivers.gtk2.common import _setDefaultEventHandlers


#############################################################################
#############################################################################
#
# UI Objects
#
# A set of standard UI objects that allow us to move more code into UIbase
# These map generic functionality to the specific UI widget set in use by
# this driver.
#
#############################################################################
#############################################################################
     
#
# UIHelper
#
# Provides a UI widget set of std functions to reduce the number of functions
# require in each UIclass listed below.
#
class UIHelper(UIWidget):
  #
  # Functions limited to the gtk2 driver
  #
  def _addToCrossRef(self, widget,gfobject, uiobject):
    self._uiDriver._WidgetToGFObj[widget]=gfobject
    self._uiDriver._WidgetToUIObj[widget]=uiobject

  def _deleteFromCrossRef(self, widget, object):
    try:
      del self._uiDriver._WidgetToGFObj[widget]
      del self._uiDriver._WidgetToUIObj[widget]
    except:
      pass

  def _addDefaultEventHandler(self,widget,eventHandler,uiDriver):
    widget._focus_sig_handler = widget.connect("focus-in-event",
                                               self._focusInHandler,\
                                               uiDriver,
                                               eventHandler)
    # add key press handlers from ../common.py
    _setDefaultEventHandlers(widget, eventHandler, 1, uiDriver)


  #
  # Override the base UIWidget functions
  #
  def show(self):
    for widget in self.widgets:
      widget.show()

  def hide(self):
    for widget in self.widgets:
      widget.hide()
          
  def showModal(self):
    print "showModal not implemented for gtk2 driver"
    for widget in self.widgets:      
      pass

  def destroy(self):
    print "destroy not implemented for gtk2 driver"
    for widget in self.widgets:
      pass
        
  def indexedFocus(self, index):
    widget = self.widgets[index]

    if widget.get_name()=='GtkCombo':
      widget=widget.entry

    # Block focus events
    try:
      widget.handler_block(widget._focus_sig_handler)
    except:
      pass
    
    #focus
    widget.grab_focus()

    # unblock focus events
    try:
      widget.handler_unblock(widget._focus_sig_handler)
    except:
      pass


  def setValue(self, value, index=0, enabled=1):
    widget = self.widgets[index]
    
    # fix for 0.5.1 (Unicode is not internal encoding)
    if widget.get_name()!='GtkCheckButton' and type(value)!=UnicodeType:
      value = unicode(value, gConfigForms('textEncoding'))
    
    if widget.get_name()=='GtkCombo':

      object = self._uiDriver._WidgetToGFObj[widget]
      
      # Check if list of allowed value (~= foreign keys, ~= dropdown content) changed
      if object.style == "dropdown" and \
             not object._field._allowedValues == widget._origAllowedValues:
        
        widget._origAllowedValues = object._field._allowedValues
        widget.set_popdown_strings(object._field._allowedValuesDescr)
        
      # set the value
      widget.entry.set_text(value)
      
    elif widget.get_name()=='GtkCheckButton':
      try:
        widget.handler_block(widget._clicked_handler)
      except:
        pass
      widget.set_active(value)
      try:
        widget.handler_unblock(widget._clicked_handler)
      except:
        pass
      
    elif widget.get_name()=='MultiLineEdit':
      widget.set_text(value)
      
    else:
      try:
        widget.handler_block(widget._insert_handler)
        widget.handler_block(widget._delete_handler)
      except:
        pass
      # print "set to '%s'" % value
      widget.set_text(value)
      try:
        widget.handler_unblock(widget._insert_handler)
        widget.handler_unblock(widget._delete_handler)
      except:
        pass      

    if enabled:
      widget.set_sensitive(1)
    else:
      widget.set_sensitive(0)

  def setCursorPosition(self, position, index=0):
    try:
      self.widgets[index].set_position(position)
    except AttributeError:
      pass  # For label-style entries

  def setSelectedArea(self, selection1, selection2, index=0):
    try:
      self.widgets[index].select_region(selection1, selection2)      
    except (AttributeError, TypeError):
      pass  # For label-style & dropdown entries


  def createWidget(self, event, spacer):
    newWidget = self._createWidget(event, spacer)
    try:
      newWidget.modify_font(self._uiDriver.mono_font)
    except:
      pass
    if event.initialize: 
      self._addToCrossRef(newWidget,event.object,self)
      
    return newWidget

  def cleanup(self, object):
    for widget in self.widgets[:]:
      try:
        del self._uiDriver._WidgetToGFObj[widget]
        del self._uiDriver._WidgetToUIObj[widget]
      except KeyError:
        pass
      self.widgets.pop(0)
      self._deleteFromCrossRef(widget, object)


  ###########################################################
  #
  #  Internal Event Handler
  #
  #

  def _focusInHandler(self, widget, event, uiDriver, eventHandler):
    #print "focus in: widget",widget
    try:
      object = uiDriver._WidgetToGFObj[widget]
    except:
      try:
        #  for the entry in a dropdown widget
        object = uiDriver._WidgetToGFObj[widget.get_parent()]
      except:
        # for the gtk.TextView widget in a MultiLineEdit Object
        object = uiDriver._WidgetToGFObj[widget._parent]
        
      
    action = events.Event('requestFOCUS',object,_form=object._form)
    # TODO: fix VETO
    # widget.emit_stop_by_name('focus-in-event')
    gtk.idle_add(eventHandler,action)
    # return gtk.TRUE


  def _focusOutHandler(self,widget, event, uiDriver, eventHandler):
    print "focus out: widget",widget
    # return gtk.TRUE # can make gtk.application segfault
