#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/button.py
#
# DESCRIPTION:
# A part of a gtk2 based user interface driver for GNUe forms: Button Widget
#
# NOTES:
#
import gtk

from gnue.common import events
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    newWidget = gtk.Button(str(object.label))
    newWidget.set_size_request(self.itemWidth, self.itemHeight)
    newWidget.get_child().modify_font(self._uiDriver.mono_font)

    event.container.put(newWidget, object.Char__x * event.widgetWidth,
                        (object.Char__y + spacer) * event.widgetHeight)

    if event.initialize:
      self._eventHandler = event.eventHandler
      newWidget.connect('clicked', self.buttonHandler, newWidget)
      self._addDefaultEventHandler(newWidget, event.eventHandler, \
                                   self._uiDriver)

    return newWidget

  def buttonHandler(self,event,widget):
    action = None
    gfObject  = self._uiDriver._WidgetToGFObj[widget]
    action = events.Event('buttonActivated',gfObject)
    self._eventHandler(action)
    return gtk.TRUE


configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
