#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/form/widget.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import string

import gtk
from gnue.common import events
from gnue.forms.uidrivers.gtk2.common import *
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

import wrappers

from gnue.forms.uidrivers.gtk2.MenuBar import MenuBar
from gnue.forms.uidrivers.gtk2.ToolBar import ToolBar

#
# UIForm
#
# Widget set specific function that creates a single instance of a Form widget
#
class UIForm(UIHelper):
  
  def __init__(self, event):
    self._uiPageList=[]
    self.statusBar = None
    UIHelper.__init__(self, event)

  
  def _createWidget(self, event, spacer):

    object = event.object

    #
    # Size based upon the form definition
    #
    self.menu_sb_space = 0

    formWidth = int(self._form._layout.Char__width)
    formHeight = int(self._form._layout.Char__height)
    self._visibleSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)
    
    self._formSize = formSize = (formWidth*self._uiDriver.widgetWidth,
                                 (formHeight+self.menu_sb_space)\
                                 *self._uiDriver.widgetHeight)


    # The main frame of this form
    if self._form.style != 'dialog':
      self.mainWindow = gtk.Window()
      self.mainWindow.set_resizable(gtk.TRUE)
      self.content_table = gtk.Table(4, 1, gtk.FALSE)
      self.mainWindow.add(self.content_table)    

      self.containerFrame = gtk.Frame()
      self.content_table.attach(self.containerFrame,
                 # X direction           Y direction
                 0, 1,                   2, 3,
                 gtk.EXPAND | gtk.FILL,  gtk.EXPAND | gtk.FILL,
                 0,                      0)
      self.createStatusBar()
      

    else:      
      self.mainWindow = gtk.Window()
      self.mainWindow.set_resizable(gtk.TRUE)
      self.containerFrame = gtk.Frame()
      self.mainWindow.add(self.containerFrame)
      borderwidth=15
      # use e.get_allocation() to compute default window sizes
      self.mainWindow.set_default_size(formWidth*self._uiDriver.widgetWidth +\
                                       borderwidth,\
                                       formHeight*self._uiDriver.widgetHeight+\
                                       borderwidth)
      
          
    self.mainWindow.connect('delete_event', self.windowExitEvent)
    self.mainWindow.set_title(str(self._form.title))
    # TODO: add icon for window
    # self.mainWindow.set_icon(...)

    # The window in which pages will be rendered 
    if object._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper(self)
    else:
      self._wrapper = wrappers.PlainWrapper(self)

    newWidget = self._wrapper.pane
    self._containerToolkitWidget = newWidget
    
    # Add the menu
    if not self._form._features['GUI:MENUBAR:SUPPRESS']:
      MenuBar(self._uiDriver, self, self._form)
    
    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar(self._uiDriver, self, self._form)
     

    # compute default window size
    #
    #paneSize=self.containerFrame.get_allocation()
    #winSize=self.mainWindow.get_allocation()
    #offsetX=winSize.width-paneSize.width
    #offsetY=winSize.height-paneSize.height
    #print "Size %s,%s" % (offsetX,offsetY)
    #(w,h)=self.containerFrame.get_size_request()
    #print 'size: %s,%s' %(w,h)
    #(w,h)=self.mainWindow.get_size_request()
    #print 'size: %s,%s' %(w,h)
      
    self._eventHandler = event.eventHandler
    self._wrapper.finalize()
    self._visible = 0

    return newWidget


  def createStatusBar(self):
    self.statusBar1 = gtk.Statusbar()
    self.statusBar2 = gtk.Statusbar()
    self.statusBar3 = gtk.Statusbar()
    self.statusBar4 = gtk.Statusbar()
    self.statusBar5 = gtk.Statusbar()

    self.statusBar1.set_has_resize_grip(gtk.FALSE)
    self.statusBar2.set_has_resize_grip(gtk.FALSE)
    self.statusBar3.set_has_resize_grip(gtk.FALSE)
    self.statusBar4.set_has_resize_grip(gtk.FALSE)
    self.statusBar5.set_has_resize_grip(gtk.TRUE)

    status_bar_table=gtk.HBox(2)
    status_bar_table.set_homogeneous(gtk.FALSE)
    status_bar_table.pack_start(self.statusBar1,gtk.TRUE,gtk.TRUE,0)
    
    status_bar_table2=gtk.HBox(4)
    status_bar_table2.pack_start(self.statusBar2,gtk.TRUE,gtk.TRUE,0)
    status_bar_table2.pack_start(self.statusBar3,gtk.TRUE,gtk.TRUE,0)
    status_bar_table2.pack_start(self.statusBar4,gtk.TRUE,gtk.TRUE,0)
    status_bar_table2.pack_start(self.statusBar5,gtk.TRUE,gtk.TRUE,0)

    status_bar_table.pack_start(status_bar_table2,gtk.TRUE,gtk.TRUE,0)

    self.content_table.attach(status_bar_table,
                 # X direction           Y direction
                 0,1,                    3, 4,
                 gtk.EXPAND | gtk.FILL,  0,
                 0,                      0)
                                                
  #
  # gotoPage
  #
  # Makes the requested page visible while hiding the others
  #
  def gotoPage(self,event):
    self._wrapper.setPage(self._uiDriver._gfObjToUIWidget[event.data].widgets[0])
          
                     
  #
  # _setStatusBar
  #
  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord,\
                    maxRecord, currentPage, maxPage):
    
    if not hasattr(self,'statusBar1'):
      return
    
    if tip != None:
      self.statusBar1.push(self.statusBar1.get_context_id("tip"),str(tip))

    if statusValue:
      context_id=self.statusBar2.get_context_id("statusValue")
      self.statusBar2.push(context_id,statusValue)
      
    if insertValue:
      context_id=self.statusBar3.get_context_id("insertValue")
      self.statusBar3.push(context_id,insertValue)

    if currentRecord and  maxRecord:
      context_id=self.statusBar4.get_context_id("currentRecord_and_maxRecord")
      messg=string.strip("%s/%s" %(currentRecord,maxRecord))
      self.statusBar4.push(context_id,messg)

    if currentPage and  maxPage:
      context_id=self.statusBar5.get_context_id("currentPage_and_maxPage")
      messg=string.strip("%s/%s"%(currentPage,maxPage))
      self.statusBar5.push(context_id,messg)


  def show(self):
    self.containerFrame.show()
    self.mainWindow.show_all()
    self._visible = 1

  def hide(self):
    self.containerFrame.hide()
    self.mainWindow.hide()
    self.mainWindow.set_modal(gtk.FALSE)
    self._visible = 0
    
  def showModal(self):
    self.mainWindow.show_all()
    self.mainWindow.set_modal(gtk.TRUE)
    self._visible = 1
    
  #############################################################################
  #
  # Internal Event Processors
  #
  # Processes the events from the widget set
  #

  #
  # windowExitEvent
  #
  # Catches the Exit event from the menu and request exit (similar to the closeTrap method of wx uidrv.)
  #
  def windowExitEvent(self,*args):
   self._uiDriver.dispatchEvent('requestEXIT',_form=self._form)
   return gtk.TRUE

