#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A QT-based user interface driver for GNUe forms.
#
# NOTES:
#
from qt import *

from gnue.common import events
from gnue.forms.uidrivers.qt.common import uiBaseEvtHandler as _Base
from gnue.forms.uidrivers.qt.common import _eventObjToQtWindow
from gnue.forms.uidrivers.qt.widgets._base import UIHelper

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    # Create a button..
    newWidget = _Button(event, self)

    # .. set the label text..
    newWidget.setText(object.label)

    # .. the examples had this, so we do to ..  :)
    newWidget.setAutoDefault(1)

    # ..and move it to it's proper place
    newWidget.setGeometry(object.Char__x*event.widgetWidth,
                          (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight,
                          self.itemWidth,self.itemHeight)

    # Attach the events to our button, and we can all go home...
    if event.initialize:
      self._eventHandler = event.eventHandler
      QObject.connect(newWidget, SIGNAL("clicked()"), self.buttonHandler)
      #QObject.connect(newWidget, PYSIGNAL("sigClicked"), self.buttonHandler)


    return newWidget

  #
  #
  def buttonHandler(self):
    self._eventHandler('buttonActivated', self._gfObject)


class _Button(_Base, QPushButton):
  def __init__(self, event, *args):
    QPushButton.__init__(self, event.container,'button%s' % id(self))
    _Base.__init__(self, event, qtClass=QPushButton, *args)


configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
