#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
"""
Entry widget
"""
# NOTES:
#
from qt import *
from gnue.common import events

from gnue.forms.uidrivers.qt.widgets._base import UIHelper
from gnue.forms.uidrivers.qt.common import _eventObjToQtWindow
from gnue.forms.uidrivers.qt.common import uiBaseEvtHandler as _Base

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    style = object.style

    if style == 'dropdown':
      if event.initialize:
        choices = object._field.allowedValues()[1]
      else:
        choices = [""]

      newWidget = _ComboBox(event, self)
      newWidget.setInsertionPolicy(QComboBox.NoInsertion)

      if event.initialize:
        newWidget.setChoices(choices)
        newWidget._origAllowedValues = object._field._allowedValues
        newWidget.setEditable(True)
        newWidget.setCurrentItem(False)

        # TODO: Listen for textChanged(), highlighted()


    elif style == 'label':
      newWidget = QLabel("", event.container)


    elif style == 'checkbox':
      newWidget = _CheckBox(event, self)

      # .. set the label text..
      newWidget.setText(object.label)

      if event.initialize:
        newWidget.setChecked(False)

        # TODO: Listen for "clicked()"


    else: # Normal text box
      if hasattr(object,'Char__height') and object.Char__height > 1:
        cls = _MultiLineEdit
      else:
        # TODO: According to the QT 3 docs, we should probably switch
        # TODO: to QTextEdit.  However, I'm not sure how to check for
        # TODO: the QT version in use :)
        cls = _SingleLineEdit

      newWidget = cls(event, self)

      # TODO: Capture textChanged, returnPressed, selectionChanged signals


    # Move it to it's proper place
    newWidget.setGeometry(object.Char__x*event.widgetWidth,
                          (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight,
                          self.itemWidth,self.itemHeight)


##    # Attach the events to our entry and call it a night...
##    if event.initialize:
##      self._eventHandler = event.eventHandler
##      _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize,self._uiDriver)


    return newWidget


###########################################################
#
#  Our custom event-riddled QObjects
#
class _SingleLineEdit (_Base, QLineEdit):
  """
  """
  def __init__(self, event, uiwidget):
    QLineEdit.__init__(self, event.container)
    _Base.__init__(self, event, uiwidget, QLineEdit)
    QObject.connect(self, SIGNAL('selectionChanged()'), self._selectionChanged)




class _MultiLineEdit (_Base, QTextEdit):
  """
  """
  def __init__(self, event, uiwidget):
    QTextEdit.__init__(self, event.container)
    _Base.__init__(self, event, uiwidget, QTextEdit)
    QObject.connect(self, SIGNAL('selectionChanged()'), self._selectionChanged)



class _ComboBox (_Base, QComboBox):
  """
  """
  def __init__(self, event, uiwidget):
    QComboBox.__init__(self, True, event.container, "Foo")
    _Base.__init__(self, event, uiwidget, QComboBox)
    QComboBox.setLineEdit(self, _SingleLineEdit(event, uiwidget))
    QObject.connect(self, SIGNAL('activated(int)'), self.__itemSelected)

  def setChoices(self,choices):
    self.__choices = choices
    for choice in choices:
      self.insertItem(choice)

  def setText(self, text):
    self.setCurrentItem(self.__choices.index(text))

  def __itemSelected(self, selection):
    selected_text = self.__choices[selection]

    uiwidget = self._uiwidget
    gfObject = uiwidget._gfObject
    action = events.Event('requestREPLACEVALUE',object=gfObject,
                          index=selection, text=selected_text,
                          _form=gfObject._form)

    # TODO: allow veto
    self._eventHandler(action)

  def focusInEvent(self,event):
    uiwidget = self._uiwidget
    gfObject = uiwidget._gfObject
    self._eventHandler('requestFOCUS',gfObject,_form=gfObject._form)
    count = uiwidget._uiDriver._IdToUIObj[id(self)].widgets.index(self)
    self._eventHandler('requestJUMPRECORD',count - gfObject._visibleIndex,_form=gfObject._form)


class _ComboBoxLineEdit(QLineEdit):
  def __init__(self, parent, *args, **parms):
    QLineEdit(*args, **parms)
    self.__parent = parent
    self.setFocusPolicy(QWidget.NoFocus)

  def focusInEvent(self,event):
    self.__parent.focusInEvent(event)


class _CheckBox (_Base, QCheckBox):
  """
  """
  def __init__(self, event, uiwidget):
    QCheckBox.__init__(self, event.container)
    _Base.__init__(self, event, uiwidget, QCheckBox)

#
#
#
configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : False,
  }
