#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/ErrorHandler.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import sys
import win32gui, win32con


def handleStartupError(errortext):
  print
  print '-' * 60
  print _("Error: %s") % errortext
  print '-' * 60

  print

  flags = win32con.MB_OK | win32con.MB_ICONERROR | win32con.MB_SYSTEMMODAL
  win32gui.MessageBox(0, _('Unable to start GNUe Forms:') + '\n\n %s' % errortext , 'GNUe Forms' , flags )

  sys.exit()
