#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/ToolBar.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import string, sys, struct, os, array
import win32api, win32gui, win32con, commctrl
from gnue.forms.uidrivers.win32.widgets._base import Win32Window
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as _BaseToolBar
from gnue.forms.uidrivers.win32.common import getNextId
from gnue.common.apps import GDebug, GConfig
from gnue.common import events

class ToolBar(_BaseToolBar):

  # Create the menu
  def init(self):
    hinst = win32api.GetModuleHandle(None)
    style = win32con.WS_CHILD | commctrl.TBSTYLE_TOOLTIPS | commctrl.TBSTYLE_FLAT #|win32con.WS_BORDER 
    styleEx = 0
    self.toolbar = mainToolBar = Win32Window(self.driver, styleEx, commctrl.TOOLBARCLASSNAME, "GNUe toolbar",
      style, 0, 0, 0, 0,
      self.container, getNextId(), hinst)

    win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_BUTTONSTRUCTSIZE, 12, 0)
    win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_SETBITMAPSIZE, 0, (24<<16) + 24) # 24x24
    win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_SETBUTTONSIZE, 0, (24<<16) + 24)  # 24x24
    #win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_AUTOSIZE, 0, 0)

    style = win32con.WS_CHILD | win32con.SS_SUNKEN
    Win32Window(self.driver, 0, 'STATIC', '', style, 0, 30, 9999, 2, self.toolbar)

    iconpath = GConfig.getInstalledBase('form_images', 'common_images')
    iconloc = os.path.join(iconpath, 'forms', 'toolbar-24x24.bmp')
    if not os.path.isfile(iconloc):
      print "*** WARNING: Cannot add 'toolbar-24x24.bmp' to toolbar"
    else:
      # commctrl.CLR_DEFAULT = 0xFF000000L produces OverflowError...
      himl = win32gui.ImageList_LoadImage(0, iconloc, 24, 0, 0xFF000000, win32con.IMAGE_BITMAP,
        win32con.LR_LOADFROMFILE | win32con.LR_SHARED | win32con.LR_CREATEDIBSECTION)
      tbab = struct.pack("ii", 0, himl)
      win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_SETIMAGELIST, 0, himl)

    self._htt = win32gui.SendMessage(mainToolBar.GetHwnd(), commctrl.TB_GETTOOLTIPS, 0, 0)
    win32gui.SendMessage(self._htt, commctrl.TTM_SETMAXTIPWIDTH , 0, 250)
    self._buttonCount = 0
    self.toolbar.Show()

    return self.toolbar

  # Add a menu item (action)
  def addAction(self, name, userAction):
    parent = self.toolbar
    label = name

    # Create an event binding in windows
    id = getNextId()
    event = 'request' + userAction.event
    self.container.Connect(id, lambda l=self.driver, e=event, f=self.form: l.dispatchEvent(events.Event(e,_form=f)))

#    TBBUTTON stru (iBitmap, idCommand, fsState, fsStyle, dwData, iString)
    tbb=struct.pack("iibbli", self._buttonCount, id, commctrl.TBSTATE_ENABLED, commctrl.TBSTYLE_BUTTON, 0, 0)
    win32gui.SendMessage(parent.GetHwnd(), commctrl.TB_ADDBUTTONS, 1, tbb)
    # i have to count myself 'coz TB_BUTTONCOUNT counts separators too...
    self._buttonCount += 1

#    TOOLINFO stru (cbSize, uFlags, hwnd, uId, rect, hinst, lpszText, lParam)
    buff = array.array('c', '%s \0x00' % (userAction.description or ''))
    addrText = buff.buffer_info()[0]
    format = "IIiIllllili"
    size = struct.calcsize(format)
    ti = struct.pack(format, size, 0, self.toolbar.GetHwnd(), id, 0, 0, 0, 0, 0, addrText, 0)
    win32gui.SendMessage(self._htt, commctrl.TTM_UPDATETIPTEXT , 0, ti)

    return (parent, id)


  # Add a separator
  def addSeparator(self):
      tbb=struct.pack("iibbli", 0, 0, commctrl.TBSTATE_ENABLED, commctrl.TBSTYLE_SEP, 0, 0)
      win32gui.SendMessage(self.toolbar.GetHwnd(), commctrl.TB_ADDBUTTONS, 1, tbb)

  # Enable a menu item
  def enableItem(self, item):
    parent, id = item
    win32gui.SendMessage(self.toolbar.GetHwnd(), commctrl.TB_ENABLEBUTTON, id, 1)

  # Disable a menu item
  def disableItem(self, item):
    parent, id = item
    win32gui.SendMessage(self.toolbar.GetHwnd(), commctrl.TB_ENABLEBUTTON, id, 0)

  def startingItem(self, item):
    return
    self.toolbar.ToggleTool(item,1)

  def endingItem(self, item):
    return
    self.toolbar.ToggleTool(item,0)
