#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
import string

from wxPython.wx import *
from gnue.common import events
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow, wxEncode, initFont
from gnue.forms.uidrivers.wx.widgets._base import UIHelper

import wrappers

from gnue.forms.uidrivers.wx.MenuBar import MenuBar
from gnue.forms.uidrivers.wx.ToolBar import ToolBar

#
# UIForm
#
# Widget set specific function that creates a single instance of a Form widget
#
class UIForm(UIHelper):

  def __init__(self, event):
    self._uiPageList=[]
    self.statusBar = None
    UIHelper.__init__(self, event)


  def _createWidget(self, event, spacer):
    object = event.object

    #
    # Size based upon the form definition
    #
    self.menu_sb_space = 0

    formWidth = int(self._form._layout.Char__width)
    formHeight = int(self._form._layout.Char__height)
    self._visibleSize = wxSize(formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)

    self._formSize = formSize = wxSize(formWidth*self._uiDriver.widgetWidth,
                      (formHeight+self.menu_sb_space)*self._uiDriver.widgetHeight)


    # The main frame of this form
    if self._form.style != 'dialog':
      if self._uiDriver._parentContainer:
        self.mainWindow = self._uiDriver._parentContainer
      else:
        self.mainWindow = wxFrame(NULL, -1, "", wxDefaultPosition)
    else:
      self.mainWindow = wxDialog(NULL,-1,"",wxDefaultPosition)

    self.containerFrame = self.mainWindow

    self.mainWindow.SetTitle(wxEncode(self._form.title))
    EVT_CLOSE(self.mainWindow,self.closeTrap)
    initFont(self.mainWindow,1)

    # The status bar
    if isinstance(self.mainWindow,wxFrame):
      self.statusBar = self.containerFrame.CreateStatusBar()
      self.statusBar.SetFieldsCount(5)
      self.statusBar.SetStatusWidths([-1,50,50,75,75])
      initFont(self.statusBar,0)


    # The window in which pages will be rendered
    if object._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper(self)
    else:
      self._wrapper = wrappers.PlainWrapper(self)

    newWidget = self._wrapper.pane
    self._containerToolkitWidget = newWidget



    # Add the menu
    if not self._form._features['GUI:MENUBAR:SUPPRESS']:
      MenuBar(self._uiDriver, self.containerFrame, self._form)

    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar(self._uiDriver, self.containerFrame, self._form)



    self._eventHandler = event.eventHandler
    self._wrapper.finalize()

    return newWidget


  #
  # closeTrap
  #
  # intercepts the applications closure and generates an event to the form requesting
  # closure.  Allows the form to control closure.  If the form approves it'll send
  # back an event closing the application
  #`
  def closeTrap(self,event):
    form = self._form

    if event.CanVeto():
      self._uiDriver.dispatchEvent('requestEXIT',_form=self._form)
    else:
      object = _eventObjTowxWindow(event)
      object.Destroy()
      # wxExit() TODO: Try and work this into navigator or here if it still hangs


  #
  # gotoPage
  #
  # Makes the requested page visible while hiding the others
  #
  def gotoPage(self,event):
    self._wrapper.setPage(self._uiDriver._gfObjToUIWidget[event.data].widgets[0])


  #
  # _setStatusBar
  #
  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord, maxRecord, currentPage, maxPage):
    if not self.statusBar:
      return

    if tip != None: self.statusBar.SetStatusText(wxEncode(tip),0)

    if statusValue:
      self.statusBar.SetStatusText(wxEncode(statusValue),1)

    if insertValue:
      self.statusBar.SetStatusText(wxEncode(insertValue),2)

    if currentRecord and  maxRecord:
      self.statusBar.SetStatusText(string.strip("%s/%s" % (currentRecord,maxRecord)),3)

    if currentPage and  maxPage:
      self.statusBar.SetStatusText(string.strip("%s/%s" % (currentPage,maxPage)),4)

    #
    # Adjust the status fields to reflect width of text in them
    #
    # This is a hack
    #
    tipWidth = -1 # Fill whatever remains
    statusWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(1))
    insertWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(2))
    recordWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(3))
    pageWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(4))

    # Either double the width if it's set or default to 5
    statusWidth = statusWidth and (statusWidth * 2) or 5
    insertWidth = insertWidth and (insertWidth * 2) or 5
    recordWidth = recordWidth and (recordWidth * 2) or 5
    pageWidth   = pageWidth   and (pageWidth   * 2) or 5

    self.statusBar.SetStatusWidths([tipWidth,statusWidth,insertWidth,recordWidth,pageWidth])


  def show(self):
    self.containerFrame.Show(1)
#    self.mainWindow.Show(1)
  def showModal(self):
    self.containerFrame.ShowModal()
#    self.mainWindow.ShowModal()

