#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# GFDesigner.py
#
# DESCRIPTION:
#
# NOTES:

import sys
from xml.sax import make_parser, handler
import string
import cPickle

_labelSpecs = {}
_loaded = 0

class MyHandler(handler.ContentHandler):

    def __init__(self, out = sys.stdout):
        handler.ContentHandler.__init__(self)
        self._out = out

        self._text = ""
        self._parent = None
        self._list_started = 0
        self._title = None
        self._link = None
        self._descr = ""
        self._labelSpecs = _labelSpecs

    # ContentHandler methods

    def startElement(self, name, attrs):
        if name == "labeldef":
          self._measurements = attrs._attrs

          self._labelSpecs[string.upper(attrs['name'])] = self._measurements
        elif name == "alias":
          self._labelSpecs[string.upper(attrs['brand'] + ' ' + attrs['part'])] = self._measurements

        self._text = ""


    def endElement(self, name):
      pass

    def characters(self, content):
      self._text = self._text + content




#
# Load all label defs
#
def initLabelDefs(file):
  global _loaded
  if not _loaded:
    parser = make_parser()
    parser.setContentHandler(MyHandler())
    parser.parse(file)
    _loaded = 1

  return _labelSpecs

#
def getByName(name):

  return _labelSpecs[name.upper()]


#
# Compile a file using python's cPickle routine
#
def compile():
  sm = initLabelDefs()



if __name__ == '__main__':
  print getByName(sys.argv[1])
