#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# email/sendmail.py
#
# DESCRIPTION:
# Basic destination adapter for writing to sendmail
#
# NOTES:
#

from gnue.common.utils import GMimeTypes
from gnue.reports import VERSION
from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base
import sys, os, string
from mimetools import choose_boundary
from MimeWriter import MimeWriter
import base64

try:
  from cStringIO import StringIO
except ImportError:
  from StringIO import StringIO



class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.usingHandle = 1
    self.input, self.tempfile = self.createTempFile()
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.usingHandle = 0
    self.input, self.tempfile = self.createTempFile()
    self.input.close()
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):

    # TODO: Eventually, I'd like for the report-filters.conf
    # TODO: file to be able to specify the extension.  We would
    # TODO: only use this method if an extension wasn't specified.
    fileExt = GMimeTypes.getExtension(mimetype)

    if self.usingHandle:
      self.input.close()

    file = self.tempfile

    email_from = gConfig('SendmailFrom')
    email_to = string.replace(string.replace(self.destination, "`",""),';','')

    sendmail = os.popen(gConfig('SendmailBin')+" '%s'" % email_to, 'w')
    sendmail.write("""From: %s
To: %s
Subject: %s
X-Mailer: GNUe Reports v%s [sendmail]
MIME-Version: 1.0
""" % (email_from, email_to, gConfig('SendmailSubject'), VERSION))

    mime = MimeWriter(sendmail)

    firstpart = mime.startmultipartbody("related")
    firstpart.write("""\
    Your email client does not support MIME encoding. Please upgrade to a MIME-enabled
email client.
""")

    subwriter = mime.nextpart()
    subwriter.addheader("Content-Transfer-Encoding", "base64")
    subwriter.addheader("Content-Disposition", "inline; filename=\"Report.%s\"" % fileExt)
    subwriter.startbody(mimetype)

    infile = open(file, 'r')
    base64.encode(StringIO(infile.read()), sendmail)
    infile.close()

    mime.lastpart()
    sendmail.close()
    self.deleteTempFile(self.tempfile)


