#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# $Id: CHGroupFooter.py 6706 2004-11-22 12:26:58Z btami $
#
# DESCRIPTION:
# Class that contains xml objects for GNUe Reports'
# "Char" markup.
#
# NOTES:
#

__all__ = ['CHGroupFooter']

from CHObject import CHObject, CHBand

class CHGroupFooter(CHObject, CHBand): 
  def __init__(self, parent=None, type='CHGroupFooter'):
    CHObject.__init__(self, parent, type=type)
    CHBand.__init__(self)

  def process(self, writer):
    for child in self._children:
      child.process(writer, self)

    if self.height > self.y+1:
      writer.newLine(self.height-self.y-1)

    self.resetBand()
