#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# FILE:
# pcl5/Writer.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Writer']

from gnue.reports.adapters.filters.Universal.Base.Writers.AbsoluteWriter import *

class Writer(AbsoluteWriter):

  # Supported features
  BITMAP_FORMATS=[]


  def initialize(self):
    # Write headers to file... initialize state variables

    # TODO: Get these dynamically
    self.orientation = 'Portrait'
    self.pagesize = 'Letter'
    self.duplex = 'Simplex'
    self.copies = 1


    # Reset (Esc E)
    self.output.write ('\x1BE')

    # Symbol set: ISO-8859-1 (Latin 1)
    self.output.write ('\x1B\x28\x30\x4E')

    # User-selectable properties
    # (Max 99 pages)
    self.output.write('\x1B\x26\x6C%02d\x58' % (min(self.copies,99)))
    self.output.write(_PAGESIZE_INIT[self.pagesize])
    self.output.write(_DUPLEX_INIT[self.duplex])
    self.output.write(_ORIENTATION_INIT[self.orientation])


  def finalize(self):
    # Write any footers to file
    pass




_PAGESIZE_INIT = {
  "Executive": "\x1B\x26\x6C\x31\x41",
  "JISEXEC (8.5 X 13 )": "\x1B\x26\x6C\x38\x41\x65",
  "Letter": "\x1B\x26\x6C\x32\x41",
  "Legal": "\x1B\x26\x6C\x33\x41",
  "Tabloid (11 X 17)": "\x1B\x26\x6C\x36\x41",
  "A4": "\x1B\x26\x6C\x32\x36\x41",
  "A3": "\x1B\x26\x6C\x32\x37\x41",
  "A5": "\x1B\x26\x6C\x34\x41",
  "JIS B5": "\x1B\x26\x6C\x34\x35\x41",
  "JIS B4": "\x1B\x26\x6C\x34\x36\x41",
  "JPOST": "\x1B\x26\x6C\x37\x31\x41",
  "JPOSTD": "\x1B\x26\x6C\x37\x32\x41",
  "Monarch": "\x1B\x26\x6C\x38\x30\x41",
  "COM 10": "\x1B\x26\x6C\x38\x31\x41",
  "B5": "\x1B\x26\x6C\x31\x30\x30\x41",
  "Custom/": "\x1B\x26\x6C\x31\x30\x32\x41",
  "DL": "\x1B\x26\x6C\x39\x30\x41",
  "C5": "\x1B\x26\x6C\x39\x31\x41",
}

_DUPLEX_INIT = {
  "Simplex": "\x1B\x26\x6C\x30\x53",
  "Duplex/Long-Edge": "\x1B\x26\x6C\x31\x53",
  "Duplex/Short-Edge": "\x1B\x26\x6C\x32\x53",
}

_ORIENTATION_INIT = {
  "Portrait": "\x1B\x26\x6C\x30\x4F",
  "Landscape": "\x1B\x26\x6C\x31\x4F",
  "Reverse Portrait": "\x1B\x26\x6C\x32\x4F",
  "Reverse Landscape": "\x1B\x26\x6C\x33\x4F",
}

_TYPEFACE_INIT = {
  "LinePrinter": "\x1B\x28\x73\x30\x54",
  "Albertus": "\x1B\x28\x73\x34\x33\x36\x32\x54",
  "Antique Olive": "\x1B\x28\x73\x34\x31\x36\x38\x54",
  "Clarendon": "\x1B\x28\x73\x34\x31\x34\x30\x54",
  "Coronet": "\x1B\x28\x73\x34\x31\x31\x36\x54",
  "Courier": "\x1B\x28\x73\x34\x30\x39\x39\x54",
  "Garamond Antiqua": "\x1B\x28\x73\x34\x31\x39\x37\x54",
  "Letter Gothic": "\x1B\x28\x73\x34\x31\x30\x32\x54",
  "Marigold": "\x1B\x28\x73\x34\x32\x39\x37\x54",
  "CG Omega": "\x1B\x28\x73\x34\x31\x31\x33\x54",
  "CG Times": "\x1B\x28\x73\x34\x31\x30\x31\x54",
  "Univers": "\x1B\x28\x73\x34\x31\x34\x38\x54",
  "Arial": "\x1B\x28\x73\x31\x36\x36\x30\x32\x54",
  "Times New Roman": "\x1B\x28\x73\x31\x36\x39\x30\x31\x54",
  "Symbol": "\x1B\x28\x73\x31\x36\x36\x38\x36\x54",
  "Wingdings": "\x1B\x28\x73\x33\x31\x34\x30\x32\x54",
}

_FONTWEIGHT_INIT = {
  "Ultra Thin": "\x1B\x28\x73\x2D\x37\x42",
  "Extra Thin": "\x1B\x28\x73\x2D\x36\x42",
  "Thin": "\x1B\x28\x73\x2D\x35\x42",
  "Extra Light": "\x1B\x28\x73\x2D\x34\x42",
  "Light": "\x1B\x28\x73\x2D\x33\x42",
  "Demi Light": "\x1B\x28\x73\x2D\x32\x42",
  "Semi Light": "\x1B\x28\x73\x2D\x31\x42",
  "Medium": "\x1B\x28\x73\x30\x42",
  "Semi Bold": "\x1B\x28\x73\x31\x42",
  "Demi Bold": "\x1B\x28\x73\x32\x42",
  "Bold": "\x1B\x28\x73\x33\x42",
  "Extra Bold": "\x1B\x28\x73\x34\x42",
  "Black": "\x1B\x28\x73\x35\x42",
  "Extra Black": "\x1B\x28\x73\x36\x42",
  "Ultra Black": "\x1B\x28\x73\x37\x42",
}

_UNDERLINE_INIT = {
  "Fixed": "\x1B\x26\x64\x30\x44",
  "Floating": "\x1B\x26\x64\x33\x44",
  "None": "\x1B\x26\x64\x40",
}

