#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GRReport.py
#
# DESCRIPTION:
# Class
#
# NOTES:
#
# HISTORY:
#

from gnue.common.definitions.GObjects import *
from gnue.common.definitions.GRootObj import GRootObj
from gnue.common.apps import GDebug
from gnue.common.logic.GTrigger import GTriggerExtension

import sys
import GRParser
import GRParameters
import layout as GRLayout
import GRSortOptions
import GRSources
import GRExceptions


class GRReport(GRootObj, GObj, GTriggerExtension):
  def __init__(self, parent=None):
    GTriggerExtension.__init__(self)
    GRootObj.__init__(self, 'report', GRParser.getXMLelements, GRParser)
    GObj.__init__(self, parent, type='GRReport')
    self._connections = None  # This will be set by GRParser.loadFile
    self._inits = (self.initialize,self.postInit)
    self._datasourceDictionary = {}
    self._parameters = None

    #
    # New trigger support
    #
    self._triggerDictionary = {}
    self._triggerns={}

    self._validTriggers = { 'ON-STARTUP':     'On-Startup',
                            'ON-EXIT':        'On-Exit' }

    #self._triggerGlobal = 1
    self._triggerFunctions = {}
    self._app = None


  def initialize(self):
    self.initTriggerSystem()
    self._triggerns.update(self._triggerNamespaceTree._globalNamespace)

  def postInit(self):
    if not self._parameters:
      self._parameters = GRParameters.GRParameters(self)

  #
  # Process the report and generate output per the report definition.
  # Destination must be a file handle (StringIO will work as well)
  #
  def process(self, dest, userParameters={}, userSortOption=None, \
      includeStructuralComments=0, omitGNUeXML=0):

    import GRDataMapper


    # Connect to databases
    GDebug.printMesg(3,"Initializing DataSource Connections")

    parameters  = self._parameters

    sortoptions = self.getChildOfType('GRSortOptions') or \
                            GRSortOptions.GRSortOptions(self)
    sources =     self.getChildOfType('GRSources')
    layout =      self.getChildOfType('GRLayout')


    #
    # Raise exceptions if _sources or _layout is None
    #
    if sources == None:
      raise NoSourcesSection, "No <sources> section has been defined."

    if layout == None:
      raise NoLayoutSection, "No <layout> section has been defined."


    # Load the user-specified parameters
    parameters.setUserParameters(userParameters)

    # .. and the sort option
    sortoptions.setSortOption(userSortOption)

    # Prepare data sources for active duty
    sources.prepare(parameters, sortoptions)

    # .. and the layout sections
    mapper = GRDataMapper.GRDataMapper(sources)
    layout.prepare(mapper, parameters)
    
    omitGNUeXML = omitGNUeXML or layout.suppressGNUeTags

    self.processTrigger('On-Startup')
    # Write common header information
    if not omitGNUeXML:

      if layout._xmlchildnamespace:
        ns = ' xmlns="%s"' % layout._xmlchildnamespace
      else:
        ns = ""

      dest.write ('<?xml version="1.0" encoding="%s"?>\n'%gConfig('textEncoding'))

      #TODO: (?) dest.write ('<!DOCTYPE ... >\n')
      dest.write ('<gnue:report-output xmlns:gnue="GNUe:Reports:Base"%s>\n' % ns)

      dest.write ("  <gnue:report-request>\n")
      dest.write ( parameters.getRunOptionsAsXML() )
      dest.write ( sortoptions.getRunOptionsAsXML() )
      dest.write ("  </gnue:report-request>\n")

    layout.process(dest, includeStructuralComments)

    if not omitGNUeXML:
      dest.write ("\n</gnue:report-output>\n")

    self.processTrigger('On-Exit')

  def getChildOfType(self, type):
    rv = None
    for child in self._children:
      if child._type == type:
        rv = child
        break
    return rv



