/*
**  AdvancedView.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>   
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "AdvancedView.h"

#include "Constants.h"
#include "ExtendedTableColumn.h"
#include "LabelWidget.h"
#include "SwitchTableView.h"


//
//
//
@implementation AdvancedView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}


//
//
//
- (void) dealloc
{
  NSDebugLog(@"AdvancedView: -dealloc");

  RELEASE(optionsColumn);
  RELEASE(enabledColumn);
  RELEASE(tableView);

  [super dealloc];
}


//
//
//
- (void) layoutView
{
  NSButtonCell *cell;
  LabelWidget *label;

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,180,430,50)
		       label: _(@"In this panel, you can set advanced options for GNUMail.app.\nGenerally, most users will simply ignore those advanced options.\nSee the User Manual for documentation on them.")];
  [self addSubview: label];


  optionsColumn = [[NSTableColumn alloc] initWithIdentifier: @"options"];
  [optionsColumn setEditable: NO];
  [[optionsColumn headerCell] setStringValue: _(@"Options")];
  [optionsColumn setMinWidth: 330];

  enabledColumn = [[ExtendedTableColumn alloc] initWithIdentifier: @"enabled"];
  [enabledColumn setEditable: NO];
  
  // We set our custom cell for the active column
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSSwitchButton];
  [cell setImagePosition: NSImageOnly];
  [enabledColumn setDataCell: cell];
  [enabledColumn setShouldUseAndSetState: YES];
  [enabledColumn setShouldUseMouse: YES];
  RELEASE(cell);

  [[enabledColumn headerCell] setStringValue: _(@"Enabled")];
  [enabledColumn setMinWidth: 50];
  
  tableView = [[SwitchTableView alloc] initWithFrame: NSMakeRect(5,5,430,165)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: optionsColumn];
  [tableView addTableColumn: enabledColumn];
  [tableView setDataSource: parent];
  [tableView setDelegate: parent];
  [tableView setTarget: parent];
  [tableView setDoubleAction: @selector(edit:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,5,430,165)];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView: tableView];
  [self addSubview: scrollView];
  RELEASE(scrollView);
}

@end
