/*
**  MessageViewWindow.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "MessageViewWindow.h"

#include "ExtendedTextView.h"
#include "Constants.h"


//
//
//
@implementation MessageViewWindow

- (void) dealloc
{
  NSDebugLog(@"MessageViewWindow: -dealloc");

  RELEASE(textScrollView);
  RELEASE(textView);

  RELEASE(previousMessage);
  RELEASE(nextMessage);
  RELEASE(delete);
  RELEASE(reply);
  RELEASE(forward);
  
  RELEASE(showOrHideAllHeaders);
  RELEASE(raw);

  [super dealloc];
}


//
//
//
- (void) layoutWindow
{  
  NSRect aRect;

  previousMessage = [[NSButton alloc] initWithFrame: NSMakeRect(24,554,64,30)];
  [previousMessage setTitle: @""];
  [previousMessage setImagePosition: NSImageOnly];
  [previousMessage setImage: [NSImage imageNamed: @"up.tiff"]];
  [previousMessage setTarget: [self windowController]];
  [previousMessage setAction: @selector(previousMessage:)];
  [previousMessage setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: previousMessage];
  
  nextMessage = [[NSButton alloc] initWithFrame: NSMakeRect(24,520,64,30)];
  [nextMessage setTitle:@""];
  [nextMessage setImagePosition: NSImageOnly];
  [nextMessage setImage: [NSImage imageNamed: @"down.tiff"]];
  [nextMessage setTarget: [self windowController]];
  [nextMessage setAction: @selector(nextMessage:)];
  [nextMessage setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: nextMessage];
  
  delete = [[NSButton alloc] initWithFrame: NSMakeRect(96,520,64,64)];
  [delete setTitle: _(@"Delete")];
  [delete setFont:[NSFont systemFontOfSize: 8]];
  [delete setImagePosition: NSImageAbove];
  [delete setImage: [NSImage imageNamed: @"delete_48.tiff"]];
  [delete setTarget: [self windowController]];
  [delete setAction: @selector(deleteMessage:)];
  [delete setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: delete];
    
  reply = [[NSButton alloc] initWithFrame: NSMakeRect(168,520,64,64)];
  [reply setTitle: _(@"Reply")];
  [reply setFont:[NSFont systemFontOfSize: 8]];
  [reply setImagePosition: NSImageAbove];
  [reply setImage: [NSImage imageNamed: @"reply_48.tiff"]];
  [reply setTarget: [self windowController]];
  [reply setAction: @selector(replyMessage:)];
  [reply setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:reply];
  
  forward = [[NSButton alloc] initWithFrame:NSMakeRect(240,520,64,64)];
  [forward setTitle: _(@"Forward")];
  [forward setFont:[NSFont systemFontOfSize: 8]];
  [forward setImagePosition: NSImageAbove];
  [forward setImage: [NSImage imageNamed: @"forward_48.tiff"]];
  [forward setTarget: [self windowController]];
  [forward setAction: @selector(forwardMessage:)];
  [forward setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:forward];
  
  showOrHideAllHeaders = [[NSButton alloc] initWithFrame:NSMakeRect(312,520,64,64)];
  [showOrHideAllHeaders setTitle: _(@"Show All Headers")];
  [showOrHideAllHeaders setFont:[NSFont systemFontOfSize: 8]];
  [showOrHideAllHeaders setImagePosition: NSImageAbove];
  [showOrHideAllHeaders setImage: [NSImage imageNamed: @"show_all_headers_48.tiff"]];
  [showOrHideAllHeaders setTarget: [self windowController]];
  [showOrHideAllHeaders setAction: @selector(showOrHideAllHeaders:)];
  [showOrHideAllHeaders setAutoresizingMask: NSViewMinYMargin];
  [showOrHideAllHeaders setTag: SHOW_ALL_HEADERS];
  [[self contentView] addSubview:showOrHideAllHeaders];
  
  raw = [[NSButton alloc] initWithFrame: NSMakeRect(384,520,64,64)];
  [raw setTitle: _(@"Raw Source")];
  [raw setFont:[NSFont systemFontOfSize: 8]];
  [raw setImagePosition: NSImageAbove];
  [raw setImage: [NSImage imageNamed: @"raw_48.tiff"]];
  [raw setTarget: [NSApp delegate]];
  [raw setAction: @selector(showRawSource:)];
  [raw setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:raw];

  textScrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,5,710,500)];
  [textScrollView setBorderType: NSBezelBorder];
  [textScrollView setHasHorizontalScroller: NO];
  [textScrollView setHasVerticalScroller: YES];
  [textScrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
 
  aRect = [[textScrollView contentView] frame];
  textView = [[ExtendedTextView alloc] init];
  [textView setFrame: aRect];
  [textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor textBackgroundColor]];
  [textView setRichText: YES];
  [textView setUsesFontPanel: YES];
  [textView setDelegate: [self windowController]];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewHeightSizable|NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize(aRect.size.width, 1E7)];

  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: NO];
  [textView setString: @""];
  
  [textScrollView setDocumentView: textView];
  
  [[self contentView] addSubview: textScrollView];

  [self setMinSize: NSMakeSize(400,450)];
}

@end
