#!/usr/bin/env python
# -*- coding: ISO-8859-15 -*-
# generated by wxGlade 0.4cvs on Sat Jul 22 16:01:11 2006

import wx

class wxgAddPatientAsStaffDlg(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: wxgAddPatientAsStaffDlg.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.MAXIMIZE_BOX|wx.MINIMIZE_BOX|wx.THICK_FRAME|wx.STAY_ON_TOP
        wx.Dialog.__init__(self, *args, **kwds)
        self._TXT_person = wx.TextCtrl(self, -1, _("Data of current patient to be displayed here."), style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_WORDWRAP|wx.NO_BORDER)
        self._TXT_short_alias = wx.TextCtrl(self, -1, "", style=wx.NO_BORDER)
        self._TXT_account = wx.TextCtrl(self, -1, "", style=wx.NO_BORDER)
        self._TXT_password = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD|wx.NO_BORDER)
        self._TXT_password_again = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD|wx.NO_BORDER)
        self._BTN_enlist = wx.Button(self, -1, _("Enlist"))
        self._BTN_cancel = wx.Button(self, -1, _("Cancel"))

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self._on_enlist_button_pressed, self._BTN_enlist)
        self.Bind(wx.EVT_BUTTON, self._on_cancel_button_pressed, self._BTN_cancel)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: wxgAddPatientAsStaffDlg.__set_properties
        self.SetTitle(_("Enlist current patient as staff member"))
        self._TXT_person.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_GRAYTEXT))
        self._TXT_person.Enable(False)
        self._TXT_short_alias.SetToolTipString(_("A short alias identifying the staff member. It is used in the clinical record among other places."))
        self._TXT_account.SetToolTipString(_("The name of the new account. The account will be created in the database with the proper access rights. Privacy restrictions are currently hardcoded to membership in the PostgreSQL group \"gm-doctors\". You can use the name of an existing account but it must not be used by any other staff member yet."))
        self._TXT_password.SetToolTipString(_("The password for the new database account. Input will not be shown."))
        self._TXT_password.SetFocus()
        self._TXT_password_again.SetToolTipString(_("The database password must be typed again to enable double-checking to protect against typos."))
        self._BTN_enlist.SetToolTipString(_("Enlist this person as staff member and associate it with the given database account."))
        self._BTN_enlist.SetDefault()
        self._BTN_cancel.SetToolTipString(_("Cancel this dialog, do not enlist new staff member.,"))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: wxgAddPatientAsStaffDlg.__do_layout
        __szr_main = wx.BoxSizer(wx.VERTICAL)
        __szr_buttons = wx.BoxSizer(wx.HORIZONTAL)
        __gszr_middle = wx.FlexGridSizer(6, 2, 0, 0)
        __lbl_person = wx.StaticText(self, -1, _("The currently selected patient is:"))
        __szr_main.Add(__lbl_person, 0, wx.ALL|wx.ADJUST_MINSIZE, 5)
        __szr_main.Add(self._TXT_person, 1, wx.LEFT|wx.RIGHT|wx.EXPAND|wx.ADJUST_MINSIZE, 5)
        __lbl_instructions = wx.StaticText(self, -1, _("To enlist this person as a staff member fill in the fields below and hit [Enlist]."))
        __szr_main.Add(__lbl_instructions, 0, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 5)
        __lbl_short_alias = wx.StaticText(self, -1, _("Short alias"), style=wx.ALIGN_RIGHT)
        __gszr_middle.Add(__lbl_short_alias, 0, wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 3)
        __gszr_middle.Add(self._TXT_short_alias, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        __lbl_account = wx.StaticText(self, -1, _("Database account"), style=wx.ALIGN_RIGHT)
        __gszr_middle.Add(__lbl_account, 0, wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 3)
        __gszr_middle.Add(self._TXT_account, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        __lbl_password = wx.StaticText(self, -1, _("Database password"), style=wx.ALIGN_RIGHT)
        __gszr_middle.Add(__lbl_password, 0, wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 3)
        __gszr_middle.Add(self._TXT_password, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        __lbl_password_again = wx.StaticText(self, -1, _("Password, again"), style=wx.ALIGN_RIGHT)
        __gszr_middle.Add(__lbl_password_again, 0, wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 3)
        __gszr_middle.Add(self._TXT_password_again, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        __gszr_middle.AddGrowableRow(0)
        __gszr_middle.AddGrowableCol(1)
        __szr_main.Add(__gszr_middle, 1, wx.LEFT|wx.RIGHT|wx.EXPAND, 5)
        __szr_buttons.Add((20, 20), 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        __szr_buttons.Add(self._BTN_enlist, 0, wx.ADJUST_MINSIZE, 0)
        __szr_buttons.Add(self._BTN_cancel, 0, wx.ADJUST_MINSIZE, 0)
        __szr_main.Add(__szr_buttons, 0, wx.ALL|wx.EXPAND, 5)
        self.SetAutoLayout(True)
        self.SetSizer(__szr_main)
        __szr_main.Fit(self)
        __szr_main.SetSizeHints(self)
        self.Layout()
        self.Centre()
        # end wxGlade

    def _on_enlist_button_pressed(self, event): # wxGlade: wxgAddPatientAsStaffDlg.<event_handler>
        print "Event handler `_on_enlist_button_pressed' not implemented!"
        event.Skip()

    def _on_cancel_button_pressed(self, event): # wxGlade: wxgAddPatientAsStaffDlg.<event_handler>
        print "Event handler `_on_cancel_button_pressed' not implemented!"
        event.Skip()

# end of class wxgAddPatientAsStaffDlg


