#!/bin/env python
# -*- python -*-
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from generate_utils import *


# figure out accumulator type.  Use biggest of input, output and tap type

def code3_to_acc_code (code3):
    if i_code (code3) == 'C' or o_code (code3) == 'C' or tap_code (code3) == 'C':
        return 'C'
    if i_code (code3) == 'F' or o_code (code3) == 'F' or tap_code (code3) == 'F':
        return 'F'
    if i_code (code3) == 'I' or o_code (code3) == 'I' or tap_code (code3) == 'I':
        return 'I'
    return 'I'                          # even short short short needs int accumulator


def init_dict (code3):
    d = {}
    d['FIR_TYPE'] = 'gr_fir_' + code3
    d['I_TYPE'] = i_type (code3)
    d['O_TYPE'] = o_type (code3)
    d['TAP_TYPE'] = tap_type (code3)
    d['FIR_BUILDER'] = char_to_builder[tap_code (code3)]
    acc_code = code3_to_acc_code (code3)
    d['ACC_TYPE'] = char_to_type[acc_code]
    if acc_code == 'C':
        d['N_UNROLL'] = '2'
        d['VRCOMPLEX_INCLUDE'] = '#include <VrComplex.h>'
    else:
        d['N_UNROLL'] = '4'
        d['VRCOMPLEX_INCLUDE'] = ''
    return d
    

def build_header (d):
    template = open_src ('gr_fir_XXX_h.t', 'r')
    output = open (d['FIR_TYPE'] + '.h', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()

def build_body (d):
    template = open_src ('gr_fir_XXX_cc.t', 'r')
    output = open (d['FIR_TYPE'] + '.cc', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()
    
def build_generic_header (d):
    template = open_src ('gr_fir_XXX_generic_h.t', 'r')
    output = open (d['FIR_TYPE'] + '_generic.h', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()

def build_generic_body (d):
    template = open_src ('gr_fir_XXX_generic_cc.t', 'r')
    output = open (d['FIR_TYPE'] + '_generic.cc', 'w')
    do_substitution (d, template, output)
    template.close ()
    output.close ()
    
def build_one (code3):
    d = init_dict (code3)
    build_header (d)
    build_body (d)
    build_generic_header (d)
    build_generic_body (d)

def generate ():
    for sigs in signatures:
        build_one (sigs)

if __name__ == '__main__':
    generate ()
