/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *    Create May 25, 1998 Matthew L. Welborn
 */
#define FOUR  1
#define EIGHT 0
#define SYNC_VERSION        1
#define PULSE_VERSION       0

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrSyncFilter.h"
#include "VrCorr.h"
#include "VrComplexPlotSink.h"
#include "VrUDPSource.h"
#include "VrFileSink.h"
#include "VrScopeSink.h"
#include "VrAWGN.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

#define DEFAULT_TPD	2600.0
int process_one = 1;
int persistent = 0;
int run=1;

VrSyncFilter<char>* filter1;
VrSyncFilter<char>* filter2;
VrScopeSink<int> *scopesink;
VrCorr<VrComplex, int>* corr; 

VrAWGN<char>* noise;
int center_freq_mult = 4; //jca 4;
int out_rate = 400000; //400000;
int symbol_rate = 2000; //2000; 
int corr_rate = 2000 * 10;
int display_width = 500;

#if 1
void set_freq_offset_1(double f) {
  filter1->setCenter_Freq(((center_freq_mult) * symbol_rate) - f);
}
void set_phase_offset_1(double f) {
  filter1->setPhase_Offset(VrComplex(cos(f*M_PI/100.0),sin(f*M_PI/100.0)));
}
void set_filter_taps_1(double t) {
  filter1->setNumber_Taps((int)t);
}
void set_timing_bump(double t) {
  filter1->setSymbol_Timing((float)t);
}
void set_noise(double f) {
  noise->setSNR((int)f);
}
#endif
void set_adv()
{
  set_timing_bump(0.05);
}
void set_ret()
{
  set_timing_bump(-0.05);
}
void set_clear()
{
  scopesink->clear();
}
void set_run()
{
  run = 1-run;
  scopesink->setRun(run);
}
void set_corr(double f)
{
  printf ("set Corr period %f\n", f);
  corr -> setCorr_Period((int)f);
}
void set_my_scale(double f) {
printf ("set Sync period %f\n", f);
//scopesink->setScale(f);
  scopesink->clear();
  corr -> setSync_Period((int)f);
}
void set_persistent()
{
	persistent = 1 - persistent;
	scopesink->set_persistent(persistent);
}

int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  int dec = out_rate / symbol_rate; 
  int dec_corr = out_rate/corr_rate;
  float dummy;

  VrUDPSource<char>* source = new VrUDPSource<char>(out_rate, 5001);
  filter1 = new VrSyncFilter<char>(dec,50,(float)((center_freq_mult) * symbol_rate),1.0/800.0);
  filter2 = new VrSyncFilter<char>(dec_corr,50,(float)((center_freq_mult) * symbol_rate),1.0/800.0);
  corr = new VrCorr<VrComplex,int>(1, 10, 2, 4);
  noise = new VrAWGN<char>();
 
  (void) VrGUISpace(guimain->top, 10);
  //  (void) VrGUILabel(guimain->top, "Correlation result", 0, 30);
  VrGUILayout *scopelay_main = guimain->top->horizontal();
  VrGUILayout *scopelay = scopelay_main->vertical();
  scopesink = new VrScopeSink<int>(scopelay, DEFAULT_TPD/2, -300, 300, display_width, 1);
  scopesink -> setSkip(1,0);
  VrGUILayout *scopelay_slider = scopelay->vertical();
  //  (void) new VrGUISlider(scopelay_slider, set_my_scale, "Time", DEFAULT_TPD/100, DEFAULT_TPD);
  VrGUILayout *scopelay2 = scopelay_main->vertical();
  VrGUILayout *scopelay_slider1 = scopelay2->vertical();
  VrGUILayout *scopelay_slider2 = scopelay2->vertical();
  VrGUILayout *scopelay2buttons = scopelay2->horizontal();
  (void) new VrGUIButton(scopelay2buttons, "Run", set_run);
  (void) new VrGUIButton(scopelay2buttons, "Store", set_persistent);
  (void) new VrGUIButton(scopelay2buttons, "Clear", set_clear);
  (void) new VrGUISlider(scopelay_slider1, set_my_scale, "Sync Period", 0.8*display_width,1.2*display_width);
  (void) new VrGUISlider(scopelay_slider2, set_corr, "Corr Period", 0, display_width);
  (void) VrGUISpace(scopelay2, 120);


  //  (void) VrGUILabel(guimain->top, "Signal constellation", 0, 30);
  VrGUILayout *scopelay2_main = guimain->top->horizontal();
  VrGUILayout *scopelay2a = scopelay2_main->vertical();
  VrComplexPlotSink* sink      = new VrComplexPlotSink(scopelay2a, (VrPulse<char,char> *)filter1,.05,2);

  VrGUILayout *scopelay2b = scopelay2_main->vertical();
#if 1
  (void) new VrGUISlider(scopelay2b, set_freq_offset_1, "Frequency error", -10.0, 10.0);
  (void) new VrGUISlider(scopelay2b, set_phase_offset_1, "Phase error", -100.0, 100.0);
  (void) new VrGUISlider(scopelay2b, set_filter_taps_1, "Filter Taps", 10.0, 200.0);
#endif
  (void) VrGUISpace(scopelay2b, 100);
  VrGUILayout *scope_controls = guimain->top->horizontal();
  (void) new VrGUIButton(scope_controls, "Advance 5%", set_adv);
  (void) new VrGUIButton(scope_controls, "Retard 5%", set_ret);
  (void) new VrGUISlider(scope_controls, set_noise, "SNR (dB)", 5.0, 72.0);

#if 1
  CONNECT(scopesink, corr, out_rate/dec_corr, 32);
  CONNECT(corr, filter2, out_rate / dec_corr, 64);
  CONNECT(filter2, source, out_rate, 8);
#endif
#if 1
  CONNECT(sink, filter1, out_rate / dec, 64);
  CONNECT(filter1, noise, out_rate, 8);
  CONNECT(noise, source, out_rate, 8);
#endif

  VrMultiTask *m = new VrMultiTask();
  m->add(sink);  
  m->add(scopesink);  
  m->start(); 
  guimain->start();

#if 1
  filter1 -> setSymbol_Timing((float)0.0);
  dummy = filter1 -> getSymbol_Period();
  cout << "Original period: " << dummy << endl;
   if(argc==2) filter1 -> setSymbol_Period(atof(argv[1]));
   if(argc==3) {
     filter1 -> setSymbol_Period(atof(argv[1]));
     filter1 -> setSymbol_Timing(atof(argv[2]));
   }
#endif
 
   while(1) {
     guimain->processEvents(10 /*ms*/);
     if (1 || process_one) {
       process_one = 0;
       m->process(); 
     }
   } /* while(1) */
}










