#include "benchmark.h"

float
benchmark_function(char *description, 
                   int times,
		   void (*func)(void *),
                   void *arg) {
    struct timeval tv_start, tv_stop;
    int i;
    gettimeofday(&tv_start, NULL);
    for(i = 0; i < times; i++) 
        func(arg);
    gettimeofday(&tv_stop, NULL);
    return TIMEVAL_DIFF(tv_start, tv_stop);
}

float
benchmark_printf(char *description, 
                 int times,
                 void (*func)(void *),
                 void *arg) {
    float elapsed = benchmark_function(description, times, func, arg);
    printf("%s: %d times, took %fs.\n", 
           description, times, elapsed);
    return elapsed;
}
