#!/usr/bin/perl -w
$num_muxers = 0;
$num_unity_muxers = 32;

$header='
#include "config.h"
#include "mixer.h"
';

$prototype='
inline void
mixer_mux_${num_sources}to${num_targets}_${width}(mixer *m,
          frame_bits_t fb_target,
          frame_bits_t *fb_sources,
          int frame_width,
          long frame_count);
';

$skeleton='
inline void
mixer_mux_${num_sources}to${num_targets}_${width}(mixer *m,
          frame_bits_t fb_target,
          frame_bits_t *fb_sources,
          int frame_width,
          long frame_count) {
    int i;
    int${width}_t *fb${width}t = (int${width}_t *)fb_target, **fb${width}s = (int${width}_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        $inner_instance
    }
}
';

$inner='
        fb${width}t[(i * m->target_channels) + $target_channel] +=
            (float)(fb${width}s[$source_channel][i] & 
                    (m->num_solos ? 
                     m->source_is_solo[$source_channel] : 
                     m->source_is_mute[$source_channel])) *
            m->mixtable[$target_channel][$source_channel];
';

$unity_prototype='
void
mixer_unity_mux_${num_channels}to${num_channels}_${width}(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count);
';

$unity_skeleton='
void
mixer_unity_mux_${num_channels}to${num_channels}_${width}(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int${width}_t *fb${width}t = (int${width}_t *)fb_target, **fb${width}s = (int${width}_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        $inner_instance
    }
}
';

$unity_inner='
        fb${width}t[mul + ${channel}] = fb${width}s[${channel}][i];';

open(C, ">muxers.c") || die ("cannot write muxers.c");
open(H, ">muxers.h") || die ("cannot write muxers.h");
open(TAB, ">muxertab.h") || die ("cannot write muxers.h");
print TAB "#ifndef MUXERTAB_H\n";
print TAB "#define MUXERTAB_H\n";
print C $header;
print H "#ifndef MUXERS_H\n";
print H "#define MUXERS_H\n";
print H $header;
print H "#define NUM_MUXERS $num_muxers\n\n";
print H "#define NUM_UNITY_MUXERS $num_unity_muxers\n\n";
print H '
struct mixer_muxer_table {
    void (*muxer)(mixer *m,
                  frame_bits_t target,
                  frame_bits_t *sources,
                  int frame_width,
                  long frame_count);
};
';
print TAB $header;
print TAB "#include \"muxers.h\"\n";

foreach $width (8,16,32) {
    print TAB "struct mixer_muxer_table muxtable_${width}[$num_muxers][$num_muxers] = {\n";
    for($num_sources = 1; 
        $num_sources < $num_muxers+1; 
        $num_sources++) {
        $tabline = "";
        for($num_targets = 1; 
            $num_targets < $num_muxers+1; 
            $num_targets++) {
            $tabline .= 
                "{ mixer_mux_${num_targets}to${num_sources}_${width} }";
            if($num_targets + 1 < $num_muxers+1) {
                $tabline .= ", ";
            }
        }
        print TAB "{ $tabline }";
        if($num_sources + 1 < $num_muxers+1) {
            print TAB ",";
        }
        print TAB "\n";
    }
    print TAB "};\n";
}

foreach $width (8,16,32) {
    print TAB "struct mixer_muxer_table muxtable_unity_${width}[$num_unity_muxers] = {\n";
    $tabline = "";
    for($num_targets = 1; 
        $num_targets < $num_unity_muxers+1; 
        $num_targets++) {
        $tabline .= 
            "{ mixer_unity_mux_${num_targets}to${num_targets}_${width} }";
        if($num_targets + 1 < $num_unity_muxers+1) {
            $tabline .= ", ";
        }
    }
    print TAB "$tabline";
    print TAB "\n";
    print TAB "};\n";
}

print TAB "#endif\n";
print TAB "\n";

foreach $width (8,16,32) {
    $target_channel = 1;
    $source_channel = 1;
    for($num_sources = 1; $num_sources < $num_muxers+1; $num_sources++) {
        for($num_targets = 1; $num_targets < $num_muxers+1; $num_targets++) {
            $inner_instance = "";
            $tabline = "";
            for($target_channel = 0; 
                $target_channel < $num_targets; 
                $target_channel++) {
                for($source_channel = 0; 
                    $source_channel < $num_sources; 
                    $source_channel++) {
                    $inner_instance .= eval "return \"$inner\";";
                }
            }
            print H eval "return \"$prototype\";";
            print C eval "return \"$skeleton\";";
        }
    }
}

foreach $width (8,16,32) {
    for($num_channels = 1; $num_channels <= $num_unity_muxers; $num_channels++) {
        $inner_instance = "";
        $tabline = "";
        for($channel = 0; 
            $channel < $num_channels; 
            $channel++) {
            $inner_instance .= eval "return \"$unity_inner\";";
        }
        print H eval "return \"$unity_prototype\";";
        print C eval "return \"$unity_skeleton\";";
    }
}

print H "#endif\n";
