/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#include <glib.h>

#include <config.h>
#include "snd.h"
#include "action.h"
#include "undo.h"
#include "pref.h"

GList *
undo_push(GList *undo_stack,
          action_group *ag) {
    GList *first;
    DEBUG("undo_stack[%d]: %p, action_group: %p\n",
          g_list_length(undo_stack), undo_stack, ag);
    if(!ag) {
        FAIL("can't push NULL action\n");
        return undo_stack;
    }

    if(g_list_length(undo_stack) > pref_get_as_int("undo_depth_max")) {
        DEBUG("undo stack depth exceeds maximum depth, destroying bottom...\n");
        first = g_list_first(undo_stack);
        undo_stack = g_list_remove_link(undo_stack, first);
        action_group_destroy((action_group *)first->data);
    }

    return g_list_append(undo_stack, ag);
}

GList *
undo_pop(GList *undo_stack) {
    GList *last = g_list_last(undo_stack);

    DEBUG("undo_stack[%d]: %p\n", 
          g_list_length(undo_stack), undo_stack);

    if(!last) {
        FAIL("no further undo information.\n");
        return undo_stack;
    }

    undo_stack = g_list_remove_link(undo_stack, last);
    action_group_do((action_group *)last->data);
    g_list_free(last);

    return undo_stack;
}

void 
undo_destroy(GList *undo_stack) {
    DEBUG("undo stack depth: %d\n", g_list_length(undo_stack));
    while(undo_stack && undo_stack->data) {
        DEBUG("destroying action_group %p\n", (action_group *)undo_stack->data);
        action_group_destroy((action_group *)undo_stack->data);
        undo_stack->data = NULL;
        undo_stack = g_list_remove(undo_stack, undo_stack->data);
    }
    g_list_free(undo_stack);
}
