;;; proud-of-gnuyahoo.scm: i am proud of gnuyahoo. are you ?
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; i know you are proud of using gnuyahoo. so let this file be
;;; automatically loaded thru init.scm
;;; to check if the other buddy is using gnuyahoo, try this command
;;; GY!> ?eval (gnuyahoo? 'buddy-name)
;;;
;;; proud-of-gnuyahoo.scm depends on color.scm
 
(ignore-message! "^.messenger")

(define (proud-of-gnuyahoo from msg)
  "tell ur buddy that you are proud of using gnuyahoo"
  (and (string=? "?messenger" msg)
       (gy-send-message-no-hook from "?messenger->gnuyahoo")
       (newline)
       (begin (gy-display (string-append "Told ["
			       from
			       "] that I'm proud of using GNUYahoo")))
       (gy-hook-return)))

(define (gnuyahoo? buddy)
  "does this buddy use gnuyahoo"
  (gy-send-message-no-hook buddy "?messenger"))
  
(define (proud-of-gnuyahoo-handler from msg)
  "handle the gnuyahoo? reply"
  (and (string=? "?messenger->gnuyahoo" msg)
       (newline)
       (begin (gy-display (string-append "Yes [" from "] is using GNUYahoo")))
       (gy-hook-return)))

(add-hook! gy-message-receive-hook proud-of-gnuyahoo)
(add-hook! gy-message-receive-hook proud-of-gnuyahoo-handler)

(gy-register-command! '("?gnuyahoo" "?gnuyahoo BUDDY\n\t- check whether a BUDDY is using gnuyahoo"))
(define (?gnuyahoo args)
  "dynamic command interface to proudofgnuyahoo extension"
  (if (= (length args) 1)
      (gnuyahoo? (car args))
      (begin
	(display "proudofgnuyahoo.scm: wrong number of arguments to ?gnuyahoo\n"))))
