/* 
   yahoo_wrapper.h: higher level wrapper to libyahoo functions

   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#ifndef _YAHOO_WRAPPER_H
#define _YAHOO_WRAPPER_H

// #include <libyahoo/libyahoo.h>
// #include <libyahoo/libyahoo-proto.h>

typedef struct gy_buddy
{
  char *group;
  char *id;
  char *real_name;
  int status;
  char *status_msg;
} gy_buddy;

char *get_received_message_from (void);

void set_current_target_buddy (char *current_target_buddy_value);
char *get_current_target_buddy (void);

void send_message (char *to, char *message);
void send_message_no_hook (char *to, char *message);

void gy_key_destroy (gpointer key);
void gy_value_destroy (gpointer data);
void build_gy_buddy_table (const void *data);
void build_gy_buddy_list ();

void show_buddy (gpointer data);
void show_ignore (gpointer data);
void display_buddy_list ();
void display_ignore_list ();
GHashTable *get_gy_buddy_list ();

// char *get_buddy_group (char *buddy);
// struct buddy *get_buddy (char *buddy_id);
// struct buddy *get_buddy_by_index (int index);
// int is_buddy_online (char *buddy_id);
// int add_buddy (char *buddy_id, int status, int in_pager, int in_chat, char *custom_message);
// int remove_buddy (char *buddy_id);
// 
// void display_buddy (struct buddy *buddy);
// void create_buddy_list ();
// void reset_all_status ();

// int process_status_packet (struct yahoo_packet *pkt, struct yahoo_rawpacket *rawpkt, char *username);
// void process_message_packet (struct yahoo_packet *pkt);
// void process_ping_packet (struct yahoo_packet *pkt);
// void process_mail_notification (struct yahoo_packet *pkt,
// 				struct yahoo_rawpacket *rawpkt);
// void process_file_transfer (struct yahoo_packet *pkt);
// int handle_yahoo_message (char *username);

#endif
